//   -*- Mode: java4; -*-
package strawberry.facelet;

import com.sun.facelets.FaceletFactory;
import javax.faces.context.ExternalContext;
import com.sun.facelets.impl.ResourceResolver;
import com.sun.facelets.impl.DefaultFaceletFactory;
import com.sun.facelets.impl.DefaultResourceResolver;
import com.sun.facelets.compiler.Compiler;
import com.sun.facelets.compiler.SAXCompiler;
import com.sun.facelets.compiler.TagLibraryConfig;
import com.sun.facelets.tag.TagDecorator;
import com.sun.facelets.tag.TagLibrary;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.logging.*;

/**
 * Created on 2007/05/18
 * @author  masa
 */
public class FaceletFactorySupport {

    // jdk1.4 logging
    protected final static Logger log = Logger.getLogger("strawberry.application");
    protected final static Logger elLog = Logger.getLogger("strawberry.el.funmap");
    public final static String PARAM_LIBRARIES = "facelets.LIBRARIES";

    public final static String PARAM_DECORATORS = "facelets.DECORATORS";
    public final static String PARAM_SKIP_COMMENTS = "facelets.SKIP_COMMENTS";


    public Compiler createCompiler() {
        return new SAXCompiler();
    }
    public void initializeCompiler(Compiler c, ExternalContext ext) {

        // load libraries
        String libParam = ext.getInitParameter(PARAM_LIBRARIES);
     //   String libParam = (String) ext.getInitParameterMap().get(PARAM_LIBRARIES);

        log.fine("42) libParam = " + libParam);
        
        if (libParam != null) {
            libParam = libParam.trim();
            String[] libs = libParam.split(";");
            URL src;
            TagLibrary libObj;
            for (int i = 0; i < libs.length; i++) {
                log.config("50) libs(" + i + ") = '" + libs[i] + "'");
                try {
                    src = ext.getResource(libs[i].trim());
                    if (src == null) {
                        throw new FileNotFoundException(libs[i]);
                    }
                    libObj = TagLibraryConfig.create(src);
                    c.addTagLibrary(libObj);
                    //       log.fine("Successfully Loaded Library: " + libs[i]);
                } catch (IOException e) {
                    log.log(Level.SEVERE, "Error Loading Library: " + libs[i],     e);
                }
            }
        }

        // load decorators
        String decParam = ext.getInitParameter(PARAM_DECORATORS);
        if (decParam != null) {
            decParam = decParam.trim();
            String[] decs = decParam.split(";");
            TagDecorator decObj;
            for (int i = 0; i < decs.length; i++) {
                try {
                    decObj = (TagDecorator) Class.forName(decs[i])
                      .newInstance();
                    c.addTagDecorator(decObj);
                    //     log.fine("Successfully Loaded Decorator: " + decs[i]);
                } catch (Exception e) {
                    log.log(Level.SEVERE,  "Error Loading Decorator: " + decs[i], e);
                }
            }
        }

        // skip params?
        String skipParam = ext.getInitParameter(PARAM_SKIP_COMMENTS);
        if (skipParam != null && "true".equals(skipParam)) {
            c.setTrimmingComments(true);
        }
    }

    /**
     *   @see com.sun.facelets.FaceletViewHandler#createFaceletFactory
     */
    public FaceletFactory createFaceletFactory(ExternalContext ec, ResourceResolver resolver) {

        Compiler c = createCompiler();
        initializeCompiler(c, ec);
        
        // refresh period
        long refreshPeriod = DEFAULT_REFRESH_PERIOD;
/*
        FacesContext ctx = FacesContext.getCurrentInstance();
        String userPeriod = ctx.getExternalContext().getInitParameter( PARAM_REFRESH_PERIO);
        if (userPeriod != null && userPeriod.length() > 0) {
            refreshPeriod = Long.parseLong(userPeriod);
        }
*/
        /*
        String resolverName = ctx.getExternalContext().getInitParameter( PARAM_RESOURCE_RESOLVER);
        if (resolverName != null && resolverName.length() > 0) {
            throw new UnsupportedOperationException("currentThread().getContextClassLoader()");
        }*/

        if (original) {
            log.config("------------------------ w肳ꂽRR͎gȂŁADefaultResourceResolver g܂");
            
            ResourceResolver defaultR = new DefaultResourceResolver();
            return new DefaultFaceletFactory(c, defaultR, refreshPeriod);
        } else {
            return new DefaultFaceletFactory(c, resolver, refreshPeriod);
        }
    }


    boolean original = true;
    

    public final static String PARAM_REFRESH_PERIO = "facelets.REFRESH_PERIOD";
    public final static long DEFAULT_REFRESH_PERIOD = 2;
}
