package strawberry.event;

import java.util.List;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;

import strawberry.event.PhaseEventEx;

import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import strawberry.lifecycle.AfterProcessValidations;
import strawberry.lifecycle.AfterRestoreView;
import strawberry.lifecycle.AnyPhase;

import java.util.logging.*;
/**
 */
public class PhaseListenerImpl implements PhaseListener {

  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.PhaseListener");

  /**
   * ̃\bh́ASẴtF[Y̏IŌĂ΂܂
   */
  public void afterPhase(PhaseEvent event) {

    FacesContext faces = event.getFacesContext();
    PhaseId pid = event.getPhaseId();
    
    int ord = pid.getOrdinal();
    
    if (ord == 1)        processAfterRestoreView(faces, faces.getViewRoot());
    if (ord == 3) processAfterProcessValidations(faces, faces.getViewRoot());

    processAnyPhase(new PhaseEventEx(event, PhaseEventEx.AFTER), faces.getViewRoot());
  }

  /**
   *  UIComponent牺̃R|[lgŁAAnyPhaseC^[tF[XĂ
   *  R|[lg΁AanyPhase\bhĂт܂
   *  Ql: strawberry.lifecycle.LifecycleImpl Ă΂
   */
  public void processAnyPhase( PhaseEventEx event, UIComponent component) throws FacesException {
    
    if (component == null) {
      log.finer("component == null");
      return;
    }
    
    if (log.isLoggable(Level.FINER))
      log.finer("processAnyPhase:" + component.getClass().getName() + ", !isRendered = " + (!component.isRendered()) );

    
    List childs = component.getChildren();
    for (int i = 0; i < childs.size(); i++) {
      UIComponent kid = (UIComponent) childs.get(i);
      processAnyPhase(event, kid);
    }
    if (component instanceof AnyPhase)  {


      AnyPhase wk = (AnyPhase) component;
      wk.anyPhase(event);
    }
  }

  public void processAfterProcessValidations(FacesContext facesContext, UIComponent component) throws FacesException {

    if (log.isLoggable(Level.FINER))
      log.finer("processAfterProcessValidations:" + component.getClass().getName() + ", !isRendered = " + (!component.isRendered()) );

    List childs = component.getChildren();
    for (int i = 0; i < childs.size(); i++) {
      UIComponent kid = (UIComponent) childs.get(i);
      processAfterProcessValidations(facesContext, kid);
    }
    if (component instanceof AfterProcessValidations)  {
      AfterProcessValidations wk = (AfterProcessValidations) component;
      wk.afterProcessValidations(facesContext);
    }
  }

  public void processAfterRestoreView(FacesContext facesContext, UIComponent component) throws FacesException {

    if (log.isLoggable(Level.FINER))
      log.finer("processAfterRestoreView:" + component.getClass().getName() + ", !isRendered = " + (!component.isRendered()) );

    List childs = component.getChildren();
    for (int i = 0; i < childs.size(); i++) {
      UIComponent kid = (UIComponent) childs.get(i);
      processAfterRestoreView(facesContext, kid);
    }
    if (component instanceof AfterRestoreView)  {
      AfterRestoreView wk = (AfterRestoreView) component;
      wk.afterRestoreView(facesContext);
    }
  }

  /**
   *  ̃\bh͑SẴtF[Y̑OɌĂ΂
   */
  public void beforePhase(PhaseEvent event) {


    FacesContext faces = event.getFacesContext();
    processAnyPhase(new PhaseEventEx(event, PhaseEventEx.BEFORE), faces.getViewRoot());
  }

  /**
   * Ώۂ̃tFCYIDԂBł͑SẴtFCYwB
   */
  public PhaseId getPhaseId() {

    return PhaseId.ANY_PHASE;
  }
}
