/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 *
 *     Copyright 2007 MASAHITO HENMI
 */
package strawberry.el;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.el.ValueExpression;
import javax.el.VariableMapper;

public class VariableMapperEx extends VariableMapper implements Externalizable {

  //private static final Log log = LogFactory.getLog(VariableMapperEx.class); //ǉ

  private static final long serialVersionUID = 1L;

  private Map vars = new HashMap();

  FacesContext fc = null;

  public VariableMapperEx(FacesContext fc) {
    this.fc = fc;
  }

  public ValueExpression resolveVariable(String variable) {
    //log.debug("resolveVariable " + variable + "  ------" );
    ValueExpression ans = (ValueExpression) this.vars.get(variable);
    if (ans == null) {
      ans = new Next6ValueExpression(variable);  
    }
    return ans;
  }

  public ValueExpression setVariable(String variable,
                                     ValueExpression expression) {
    //log.debug("setVariable " + variable + ", " + expression +    "------" );
    return (ValueExpression) this.vars.put(variable, expression);
  }

  public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    this.vars = (Map) in.readObject();
  }

  public void writeExternal(ObjectOutput out) throws IOException {
    out.writeObject(this.vars);
  }
}
