/*
 * Copyright (C)  2007 Masahito Henmi, All rights reserved.
 */
package strawberry.el;


import javax.el.ELContext;
import javax.el.ELException;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import java.util.logging.*;
import javax.faces.el.VariableResolver;
/**
 * Created on 2007/02/19
 *
 *   2007/04/10  FacesContext̓VACYłȂ̂ŁA
 *               FacesContext facesContext = FacesContext.getCurrentInstance();
 *               Ŏ擾悤ɕύX
 *
 *   2007/06/10  new VariableResolverImpl()   =>   getVariableResolver()
 *
 * @author masa
 */
public class Next6ValueExpression extends ValueExpression {

  // jdk1.4 logging
  protected final static Logger elLog = Logger.getLogger("strawberry.el.variable");

  String name;

  public Next6ValueExpression( String name) {
    this.name = name;
  }

  public void setValue(ELContext context, Object value) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, ELException {
    
    elLog.severe("Next6ValueExpression#setValue **************** UnsupportedOperationException");
    throw new UnsupportedOperationException();
  }

  public boolean isReadOnly(ELContext context) throws NullPointerException, PropertyNotFoundException, ELException {
    throw new UnsupportedOperationException();
  }

  public Object getValue(ELContext context) throws NullPointerException, PropertyNotFoundException, ELException {

    FacesContext facesContext = FacesContext.getCurrentInstance(); //2007.04.10

//    VariableResolverImpl impl = new VariableResolverImpl();

    VariableResolver impl = facesContext.getApplication().getVariableResolver();

    if (elLog.isLoggable(Level.FINE)) {
      elLog.fine("VariableResolver = " + impl + ", name = '" + name + "'");
    }

    return impl.resolveVariable(facesContext, name);
  }

  public Class getType(ELContext context) throws NullPointerException, PropertyNotFoundException, ELException {
    throw new UnsupportedOperationException();
  }

  public boolean isLiteralText() {
    throw new UnsupportedOperationException();
  }

  public String getExpressionString() {
    throw new UnsupportedOperationException();
  }

  public Class getExpectedType() {
    throw new UnsupportedOperationException();
  }

  public boolean equals(Object obj) {
    return false;
  }

  public String toString() {
    return "Next6ValueExpression[name = " + name + "]";
  }

  public int hashCode() {
    return 123;
  }

}
