/*  -*- Mode: java4; -*-
 * 
 * 
 * Copyrighted [2007] [MASAHITO HENMI]
 * 
 * 
 */
package strawberry.context;

//import strawberry.viewhandler.FaceletViewHandler;
import strawberry.viewhandler.FaceletFactoryAware;
import com.sun.facelets.el.ELAdaptorEx;
import com.sun.facelets.impl.DefaultFaceletFactory;
import java.util.List;
import java.util.Map;

// 2007.2.26
import javax.el.ELContext;
import javax.el.FunctionMapper;
import javax.faces.application.Application;
import javax.faces.component.UIViewRoot;
import strawberry.el.DeserializedFunctionMapper;
import strawberry.el.GlobalELContext;

import javax.faces.application.Application;
import javax.faces.context.ExternalContext;
import javax.faces.render.RenderKitFactory;

import com.sun.faces.context.FacesContextImpl;

import java.util.logging.*;

public class FacesContextEL extends FacesContextImpl implements ELAdaptorEx {

    // jdk1.4 logging
    protected final static Logger log = Logger.getLogger("strawberry.faces");
    
    public FacesContextEL(ExternalContext ec, RenderKitFactory rkf, Application app) {
        super(ec, rkf, app);
    }
    
    public FacesContextEL(ExternalContext ec) {
        super(ec, null, null);
    }

    public ELContext getELContextAtRestoreView() {

        FacesContextImpl fci = this;
        ELContext elContext = fci.getELContext();

        UIViewRoot uivr = this.getViewRoot();
        if (uivr != null) {
            if (log.isLoggable(Level.FINER)) log.finer("51) " + uivr);
            
            Boolean restoredFlag = (Boolean) uivr.getAttributes().get(RESTORED_VIEW_KEY);

            if (log.isLoggable(Level.FINER))
                log.finer("63) restoredFlag = " + restoredFlag);
            
            if (restoredFlag != null && restoredFlag.booleanValue()) {
                //  ꂽr[
                //  FunctionMapper̎A
                FunctionMapper fm = elContext.getFunctionMapper();
                log.fine("65) FunctionMapper = " + fm + " TODO: FunctionMapper̎A");

                Map funcMap = (Map) uivr.getAttributes().get("FunctionMapper");

                if (funcMap == null) {
                    log.fine("71) funcMap łB܂");
                } else {
                    restoreFunctionMapper(fci.getApplication(), (GlobalELContext)elContext, funcMap);
                }
            }
        }

        return elContext;
    }

    /**
     *  r[XgAꂽFunctionMapperč쐬
     */
    private static void restoreFunctionMapper(Application app, GlobalELContext elContext, Map funcMap) {

//        FaceletViewHandler fvh = (FaceletViewHandler) app.getViewHandler();
        FaceletFactoryAware fvh = (FaceletFactoryAware) app.getViewHandler();
        
        DefaultFaceletFactory dff = (DefaultFaceletFactory) fvh.getFaceletFactory();

        //  JDK5 java.lang.Compiler
        com.sun.facelets.compiler.Compiler compiler = dff.getCompiler();

        List tagLibs = compiler.getTagLibraries();

        //     VACYꂽuhdv߂ꂽƂ FunctionMapper𕜌
        FunctionMapper fm = new DeserializedFunctionMapper(funcMap, tagLibs);
        elContext.setFunctionMapper(fm);
    }
}
