//   -*- Mode: java4; -*-
package strawberry.config;

import com.sun.faces.renderkit.RenderKitFactoryImpl;
import com.sun.faces.util.Util;
import com.sun.faces.config.beans.*;

import javax.faces.context.ExternalContext;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import java.util.Map;
import java.util.logging.*;
/**
 * Created on 2007/02/11
 * @author masa
 */
public class RenderKitFactoryInitializer {

    // jdk1.4 logging
    protected final static Logger log = Logger.getLogger("strawberry.init.ren"); // 07.5.21

    public RenderKitFactory configureRenderKits(ExternalContext ec, Object fallback) {
        
        RenderKitFactory rkFactory = new RenderKitFactoryImpl();

        RenderKit rk = rkFactory.getRenderKit(null, RenderKitFactory.HTML_BASIC_RENDER_KIT);

        if (log.isLoggable(Level.FINER))
            log.finer("30) rk = " + rk);

        configureRenderKits( rk);

        return rkFactory;
    }

    public void configureRenderKits(RenderKit rk) {
        addRenderKits(rk, standardRenders);
    }

    public void addRenderKits(RenderKit rk, String[] renders) {
        for (int i = 0; i < renders.length; i+= 3) {
            String componentFamily = renders[i + 0];
            String rendererType    = renders[i + 1];
            String rendererClass   = renders[i + 2];

            if (log.isLoggable(Level.FINEST))
                log.finest("133) addRenderer(" + componentFamily + ", " + rendererType + ", " + rendererClass);

            Renderer r = null;
            try {
                r = (Renderer)  Util.loadClass( rendererClass, this).newInstance();
            } catch (Exception ex) {
                log.severe(ex.getMessage() + " --- "  + rendererClass);
            }
            if (r != null)
                rk.addRenderer(componentFamily,  rendererType,  r);
        }

        log.finer("145) " + (renders.length / 3) + "̕W_ǉ܂B");

    }

    String[] standardRenders = {
        "facelets",             "facelets.ui.Repeat",  "com.sun.facelets.component.RepeatRenderer",

        // ςƁACxg̃u[hLXgȂȂH
        //    "javax.faces.Command",   "javax.faces.Button", "com.sun.faces.renderkit.html_basic.ButtonRenderer",
        "javax.faces.Command",   "javax.faces.Button", "strawberry.renderkit.html_basic.ButtonRenderer",

        // 2007.6.1
        "javax.faces.Output",   "javax.faces.Link",   "com.sun.faces.renderkit.html_basic.OutputLinkRenderer",

        "javax.faces.Command",   "javax.faces.Link",   "com.sun.faces.renderkit.html_basic.CommandLinkRenderer",
        "javax.faces.Data",      "javax.faces.Table",  "com.sun.faces.renderkit.html_basic.TableRenderer",

        "javax.faces.Form",     "javax.faces.Form",  "com.sun.faces.renderkit.html_basic.FormRenderer",
        "javax.faces.Graphic", "javax.faces.Image", "com.sun.faces.renderkit.html_basic.ImageRenderer",
        "javax.faces.Input",   "javax.faces.Hidden", "com.sun.faces.renderkit.html_basic.HiddenRenderer",
        "javax.faces.Input",   "javax.faces.Secret", "com.sun.faces.renderkit.html_basic.SecretRenderer",
        "javax.faces.Input",    "javax.faces.Text",  "com.sun.faces.renderkit.html_basic.TextRenderer",
        "javax.faces.Input",   "javax.faces.Textarea", "com.sun.faces.renderkit.html_basic.TextareaRenderer",


        "javax.faces.Messages", "javax.faces.Messages", "com.sun.faces.renderkit.html_basic.MessagesRenderer",
        "javax.faces.Message", "javax.faces.Message", "com.sun.faces.renderkit.html_basic.MessageRenderer",
        "javax.faces.Output", "javax.faces.Format", "com.sun.faces.renderkit.html_basic.OutputMessageRenderer",
        "javax.faces.Output", "javax.faces.Label",  "com.sun.faces.renderkit.html_basic.LabelRenderer",


        "javax.faces.Output", "javax.faces.Text", "com.sun.faces.renderkit.html_basic.TextRenderer",

        "javax.faces.Panel", "javax.faces.Grid", "com.sun.faces.renderkit.html_basic.GridRenderer",
        "javax.faces.Panel", "javax.faces.Group", "com.sun.faces.renderkit.html_basic.GroupRenderer",

        "javax.faces.SelectBoolean", "javax.faces.Checkbox", "com.sun.faces.renderkit.html_basic.CheckboxRenderer",

        "javax.faces.SelectMany", "javax.faces.Checkbox", "com.sun.faces.renderkit.html_basic.SelectManyCheckboxListRenderer",

        "javax.faces.SelectMany", "javax.faces.Listbox", "com.sun.faces.renderkit.html_basic.ListboxRenderer",
        "javax.faces.SelectMany", "javax.faces.Menu",  "com.sun.faces.renderkit.html_basic.MenuRenderer",
        "javax.faces.SelectOne", "javax.faces.Listbox", "com.sun.faces.renderkit.html_basic.ListboxRenderer",
        "javax.faces.SelectOne", "javax.faces.Menu", "com.sun.faces.renderkit.html_basic.MenuRenderer",
        "javax.faces.SelectOne", "javax.faces.Radio", "com.sun.faces.renderkit.html_basic.RadioRenderer",

        "strawberry.Input",    "javax.faces.Text",  "strawberry.renderkit.html_basic.TextRenderer",

        "javax.faces.Output", "stateRenderer",  "strawberry.renderkit.html_basic.StateRenderer",

        "javax.faces.Output", "debugRenderer",  "strawberry.renderkit.html_basic.DebugRenderer",
        "javax.faces.Output", "debugRendererRenderer",  "strawberry.renderkit.html_basic.DebugRendererRenderer",
        
    };

}
