package strawberry.config;

import com.sun.faces.config.ManagedBeanFactory;
import javax.faces.context.FacesContext;
import javax.faces.context.ExternalContext;
import javax.sql.DataSource;
import java.util.logging.*;
/**
 *  AvP[V ̃NX[_ŃIuWFNg𐶐B
 *  Tomcat3œ߂̑΍B
 */
public class ManagedBeanFactoryApp extends ManagedBeanFactory {
  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.bean");

  public final static String BEAN_NAME = "strawberry.config.ManagedBeanFactoryApp.ClassLoader";

  public final static String DATASOURCE_NAME = "strawberry.config.ManagedBeanFactoryApp.DataSource";

  /**
   *   tomcat3̏ꍇ
   *   Thread.currentThread().getContextClassLoader() ܂ȂB
   *   ̖R[h
   */
  protected Object createBeanInstance(String className, FacesContext context) throws Exception {

    ExternalContext ec = context.getExternalContext();
    
    String beanName = ec.getInitParameter(BEAN_NAME);

    if (beanName == null) {

      log.info("32)   currentThread().getContextClassLoader() ------ ***" );
      return super.createBeanInstance(className, context);
    }

    
    Object ref = ec.getApplicationMap().get(beanName);

    if (ref == null) throw new NullPointerException(beanName);
    //  6.11 fix
    
    // @see   strawberry.tools.ClassLoadUtil
    ClassLoader loader = ref.getClass().getClassLoader();
    String strLoader = loader.toString();
    if (strLoader.indexOf("@") < 0) {
      strLoader = strLoader + "@" + Integer.toHexString(loader.hashCode());
    }

    if (log.isLoggable(Level.FINER))
      log.finer("32)  " + strLoader + " ------- ŃIuWFNg@" );

    Class clazz = loader.loadClass(className);
    
    Object obj = clazz.newInstance();
/*
    if (obj instanceof DataSourceAware) {
      DataSourceAware aware = (DataSourceAware) obj;
      injectDataSource(aware, ec);
    }
*/
    return obj;
  }

/*
  public void injectDataSource(DataSourceAware aware, ExternalContext ec) {

    String beanName = ec.getInitParameter(DATASOURCE_NAME);

    if (beanName == null) throw new NullPointerException(DATASOURCE_NAME);
    
    Object ds = ec.getApplicationMap().get(beanName);

    if (ds == null) throw new NullPointerException(beanName);

    aware.setDataSource((DataSource) ds);
  }
*/

}
