package strawberry.config;

//import com.sun.faces.modify.*;

import java.util.*;
import javax.servlet.ServletContext;
import com.sun.faces.config.*;
import com.sun.faces.config.beans.*;
import strawberry.application.ApplicationAssociate;

import strawberry.xmlconfig.*;
import java.util.logging.*;
/**
 * Created on 2007.2.2
 *
 * @author masa
 */
public class FacesConfigFactory {

  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.config.FacesConfigFactory");

  static Hashtable hash = new Hashtable();

  /*
   */

  // Xml add 070514
  public static void processXmls(String[] xmlPaths, ServletContext sc, String type) throws Exception {

    ConfigureListener cl = new ConfigureListener();
    
    if ("ManagedBeanFactoryApp".equals(type)) {

      String xmlPath = xmlPaths[0];
      
      log.info("73) SAXŁA xml܂ ");
      
      FacesConfigBean configBean = FacesConfigFactory.getFacesConfigBean(xmlPath);
      
      //  typeɉāAClassLoadeřo@ς
      cl.setManagedBeanFactoryClass(type);
      cl.configure(sc, configBean);
      // ServletContextɍꂽApplicationAssociateۑ

      // ServletContextAOꂽApplicationAssociateo
      ApplicationAssociate associate = ApplicationAssociate.getInstance(sc);

      for (int i = 1; i < xmlPaths.length; i++) {

        String xmlPath2 = xmlPaths[i];

        FacesConfigBean configBean2 = FacesConfigFactory.getFacesConfigBean(xmlPath2);
        ManagedBeanBean[] config = configBean2.getManagedBeans();
        cl.configure(config, associate);
      }

    } else if ("digester".equals(type)) {

      log.info("96) digesterg xml܂ ");
      
      FacesConfigBean fcb = new FacesConfigBean();

      ConfigureListenerOrig orig = new ConfigureListenerOrig();
      ConfigServletContext csc = new ConfigServletContext(sc);

      csc.addInitParameter("com.sun.faces.validateXml", "true");
      csc.addInitParameter("javax.faces.CONFIG_FILES", "faces-config.xml");

      orig.step1to5(csc, fcb); // fcb  XML̓eǉ

      ComponentBean[] bean1 = fcb.getComponents();
      for (int i = 0; i < bean1.length; i++) {
        log.info("getComponents " + i + " = " + bean1[i].getComponentClass());
      }

      //  typeɉāAClassLoadeřo@ς
      cl.setManagedBeanFactoryClass("ManagedBeanFactoryApp");
      cl.configure(sc, fcb);
      // ServletContextɍꂽApplicationAssociateۑ

    } else {
      throw new IllegalArgumentException();
    }
  }



  /**
   *
   */
  public static synchronized FacesConfigBean getFacesConfigBean(String path) {

    Object wk = hash.get(path);
    if (wk != null) {
      log.info("(64) FacesConfigBean LbVɌ̂łԂ");
      return (FacesConfigBean) wk;
    }

    FacesConfigLoader loader = new FacesConfigLoader();
    FacesConfigBean bean = loader.load(path);
    hash.put(path, bean);
    log.info("(70) FacesConfigBean VK쐬ăLbVɓo^");
    return bean;
  }
}
