package strawberry.config;

import com.sun.faces.application.ConfigNavigationCase;
import com.sun.faces.config.*;
import com.sun.faces.config.beans.*;
import java.util.logging.*;
import javax.faces.application.NavigationHandler;
import javax.servlet.ServletContext;

import strawberry.application.ApplicationAssociate;
/**
 */
public class ConfigureListener {

  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.init.bean");

  /**  */
  public void configure(ServletContext servletContext, FacesConfigBean config)  throws Exception {

    configure( servletContext, config.getManagedBeans());
  }

  public void configure(ServletContext servletContext, ManagedBeanBean[] mConf)  throws Exception {

    log.fine("(26) -------------- configure Jn");
    
    ApplicationAssociate associate =  new ApplicationAssociate();
    
    configure(mConf, associate);

    servletContext.setAttribute(ApplicationAssociate.ASSOCIATE_KEY, associate); // ۑ

//    NavigationHandler navHand = application.getNavigationHandler();
//    log.fine("(37) -------------- " + navHand );
    
    configureNavigationRules(/*navHand,*/ associate);
    
    log.fine("(41) -------------- configure I");
  }


  public void configureNavigationRules( ApplicationAssociate associate) {

    log.fine("(48) -------------- configureNavigationRules Jn");

    //if (navHand == null) {
    //  log.error ("navHand == null");
    //  return;
    //}

    NavigationRuleBean rule1 = new NavigationRuleBean();

    NavigationCaseBean rule1case1 = new NavigationCaseBean();
    rule1case1.setFromAction("/par/FPage12");
    rule1case1.setFromOutcome("success");
    rule1case1.setRedirect(true);
    rule1case1.setToViewId("/servlet/MainMenuServlet");
    rule1.addNavigationCase(rule1case1);


    NavigationRuleBean rule2 = new NavigationRuleBean();

    NavigationCaseBean rule2case1 = new NavigationCaseBean();
    rule2case1.setFromAction("*"); ////////
    rule2case1.setFromOutcome("success");
    rule2case1.setRedirect(true);
    rule2case1.setToViewId("/servlet/MainMenuServlet");
    rule2.addNavigationCase(rule2case1);

    NavigationRuleBean[] arr = new NavigationRuleBean[] { rule1, rule2 };

    configure(arr, associate);
  }

  private void configure(NavigationRuleBean config[], ApplicationAssociate associate) {

    if (config == null) {
      return;
    }
    
    if (null == associate) {
      return;
    }
/*
    for (int i = 0; i < config.length; i++) {
      if (log.isLoggable(Level.FINER)) {
        log.finer("addNavigationRule(" +
                  config[i].getFromViewId() + ')');
      }
      NavigationCaseBean ncb[] = config[i].getNavigationCases();
      for (int j = 0; j < ncb.length; j++) {
        if (log.isLoggable(Level.FINER)) {
          log.finer("97) addNavigationCase(" +
                 ncb[j].getFromAction() + ',' +
                 ncb[j].getFromOutcome() + ',' +
                 ncb[j].isRedirect() + ',' +
                 ncb[j].getToViewId() + ')');
        }
        ConfigNavigationCase cnc = new ConfigNavigationCase();
        if (config[i].getFromViewId() == null) {
          cnc.setFromViewId("*");
        } else {
          cnc.setFromViewId(config[i].getFromViewId());
        }
        cnc.setFromAction(ncb[j].getFromAction());
        String fromAction = ncb[j].getFromAction();
        if (fromAction == null) {
          fromAction = "-";
        }
        cnc.setFromOutcome(ncb[j].getFromOutcome());
        String fromOutcome = ncb[j].getFromOutcome();
        if (fromOutcome == null) {
          fromOutcome = "-";
        }
        cnc.setToViewId(ncb[j].getToViewId());
        String toViewId = ncb[j].getToViewId();
        if (toViewId == null) {
          toViewId = "-";
        }
        cnc.setKey(cnc.getFromViewId() + fromAction + fromOutcome);
        if (ncb[j].isRedirect()) {
          cnc.setRedirect("true");
        } else {
          cnc.setRedirect(null);
        }
        associate.addNavigationCase(cnc);
      }
    }*/
  }

  Class managedBeanFactoryClass = null;

  private void setManagedBeanFactoryClass(Class clazz) {
    managedBeanFactoryClass = clazz;
  }
  public void setManagedBeanFactoryClass(String type) {

    //  typeɉāAClassLoadeřo@ς
    if ("ManagedBeanFactoryApp".equals(type)) {
      setManagedBeanFactoryClass(ManagedBeanFactoryApp.class);
    } else {
      throw new IllegalArgumentException();
    }
  }  
  
  
  public void configure(ManagedBeanBean config[], ApplicationAssociate associate) throws Exception {
    if (config == null) {
      return;
    }

    if (null == associate) {
      log.fine("157) return associate is null  !! ");
      return;
    }

    for (int i = 0; i < config.length; i++) {

      if (log.isLoggable(Level.FINE))
        log.fine("164) addManagedBean(" + config[i].getManagedBeanName() + ',' + config[i].getManagedBeanClass() + ')');

      ManagedBeanFactory mbf = (ManagedBeanFactory) managedBeanFactoryClass.newInstance();
      mbf.setManagedBeanBean(config[i]);

      associate.addManagedBeanFactory(config[i].getManagedBeanName(),  mbf);
    }
  }
}
