package strawberry.config;

import com.sun.faces.config.beans.*;

import com.sun.faces.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.application.*;
import javax.faces.context.ExternalContext;

import java.util.logging.*;

/**
 * AvP[V
 * @see com.sun.faces.config.ConfigureListener
 */
public class ApplicationInitializer {

    // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.init.app");

  public void configureApplication(ExternalContext ec, Application application) throws Exception {
    
    configureComponents(application);
    configureConverters(application);
    configureLocale(application);
    configureValidators( application );

  }

  

  
  String[] validators = {
    "javax.faces.DoubleRange",             "javax.faces.validator.DoubleRangeValidator",
    "javax.faces.Length",                  "javax.faces.validator.LengthValidator",
    "javax.faces.LongRange",               "javax.faces.validator.LongRangeValidator",

    "jsfutil.validator.FutureValidator",   "jsfutil.validator.FutureValidator",

  };

  public void configureValidators( Application application ) {

    for (int i = 0; i < validators.length; i += 2) {
      String validatorId    = validators[i + 0];
      String validatorClass = validators[i + 1];

      if (log.isLoggable(Level.FINEST)) {
        log.finest("addValidator(" + validatorId + ',' +   validatorClass + ")    @@@");
      }
      
      application.addValidator(validatorId, validatorClass);
    }
  }

  private static final Class PRIM_CLASSES_TO_CONVERT[] = {
    java.lang.Boolean.TYPE,
    java.lang.Byte.TYPE,
    java.lang.Character.TYPE,
    java.lang.Double.TYPE,
    java.lang.Float.TYPE,
    java.lang.Integer.TYPE,
    java.lang.Long.TYPE,
    java.lang.Short.TYPE
    };

  /**
   * <p>Array of known converters for primitive types.</p>
   */
  private static final String CONVERTERS_FOR_PRIMS[] = {
    "javax.faces.convert.BooleanConverter",
    "javax.faces.convert.ByteConverter",
    "javax.faces.convert.CharacterConverter",
    "javax.faces.convert.DoubleConverter",
    "javax.faces.convert.FloatConverter",
    "javax.faces.convert.IntegerConverter",
    "javax.faces.convert.LongConverter",
    "javax.faces.convert.ShortConverter"
    };



  String[]  converId = {
    "javax.faces.BigDecimal",    "javax.faces.convert.BigDecimalConverter",
    "javax.faces.BigInteger",    "javax.faces.convert.BigIntegerConverter",
    "javax.faces.Boolean",    "javax.faces.convert.BooleanConverter",
    "javax.faces.Byte",    "javax.faces.convert.ByteConverter",
    "javax.faces.Character",    "javax.faces.convert.CharacterConverter",
    "javax.faces.DateTime",    "javax.faces.convert.DateTimeConverter",
    "javax.faces.Double",    "javax.faces.convert.DoubleConverter",
    "javax.faces.Float",    "javax.faces.convert.FloatConverter",
    "javax.faces.Integer",    "javax.faces.convert.IntegerConverter",
    "javax.faces.Long",    "javax.faces.convert.LongConverter",
    "javax.faces.Number",    "javax.faces.convert.NumberConverter",
    "javax.faces.Short",    "javax.faces.convert.ShortConverter",

    // W

    "jsfutil.IntegerConverterAllowsNullString",    "jsfutil.convert.IntegerConverter",

    // BigDecimal Integer ɂRo[^
    "jsfutil.IntegerConverterAllowsBigDecimal",    "jsfutil.convert.IntegerConverterAllowsBigDecimal",

    "jsfutil.RedirectConverter",                   "jsfutil.convert.RedirectConverter",

  };

  private void configureConverters(Application application ) throws Exception {

    int i = 0, len = 0;

    // at a minimum, configure the primitive converters
    for (i = 0, len = PRIM_CLASSES_TO_CONVERT.length; i < len; i++) {
      if (log.isLoggable(Level.FINEST)) {
        log.finest("addConverterByClass(" + PRIM_CLASSES_TO_CONVERT[i] + ',' +
                  CONVERTERS_FOR_PRIMS[i] + ")    @@@");
      }
      application.addConverter(PRIM_CLASSES_TO_CONVERT[i], CONVERTERS_FOR_PRIMS[i]);
    }

    addConverterFromArray(application, converId);

    /* JX^}CYǉł悤ɂ
    if (userConverterArray != null) {
      addConverterFromArray(application, userConverterArray);
    }*/
  }

  private void addConverterFromArray(Application application, String[] array) throws Exception {

    for (int j = 0; j < array.length; j += 2) {
      String converterId = array[j + 0];
      String converterClass = array[j + 1];
      if (log.isLoggable(Level.FINER)) {
        log.finer("240) converterId ------------------------  z񂩂ǉ ");
        log.finer("241) converterId = " + converterId + ", converterClass = " +  converterClass);
      }
      application.addConverter(converterId,  converterClass);
    }
  }


  
  //Configure Standard By-Id Converters
  //C:/javasrc/jsf1.1_02fcs-src/jsf-ri/src/com/sun/faces/jsf-ri-config.xml


  public void configureLocale(Application application) {

    application.setDefaultLocale(Util.getLocaleFromString("ja"));

    String[] values = {"en", "ja"};

    List locales = new ArrayList();
    for (int i = 0; i < values.length; i++) {
      if (log.isLoggable(Level.FINEST)) {
        log.finest("addSupportedLocale(" + values[i] + ')');
      }
      locales.add(Util.getLocaleFromString(values[i]));
    }
    application.setSupportedLocales(locales);
  }
  
  
  String[] otherComponents = {

    "strawberry.HtmlInputText",           "strawberry.component.html.HtmlInputText",
    "strawberry.HtmlOutputText",          "strawberry.component.html.HtmlOutputText",
  };
  


  public void configureComponents(Application application) {
    SetupUtil util = new SetupUtil();
    util.addStandardComponents( application);
    util.addComponents( application, otherComponents);
  }


  
}
