/*    -*- Mode: java4; -*-
 * $Id: ApplicationAssociate.java,v 1.3.26.1.2.2.2.1 2006/04/12 19:32:02 ofung Exp $
 */

/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at
 * https://javaserverfaces.dev.java.net/CDDL.html or
 * legal/CDDLv1.0.txt. 
 * See the License for the specific language governing
 * permission and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at legal/CDDLv1.0.txt.    
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * 
 * "Portions Copyrighted [2007] [MASAHITO HENMI]"
 * 
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */
package strawberry.application;

import com.sun.faces.application.ConfigNavigationCase;
import com.sun.faces.util.Util;
import com.sun.faces.RIConstants;

import javax.servlet.ServletContext;

import java.util.*;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.faces.context.FacesContext;
import javax.faces.context.ExternalContext;
import javax.faces.FacesException;
import javax.servlet.ServletContext;
import com.sun.faces.config.ManagedBeanFactory;
import com.sun.faces.config.beans.*;
import java.util.logging.*;
/**
 *   tomcat3 ̃NX[_ strawberry.config.ManagedBeanFactoryApp
 *
 * <p>Break out the things that are associated with the Application, but
 * need to be present even when the user has replaced the Application
 * instance.</p>
 * 
 * <p>For example: the user replaces ApplicationFactory, and wants to
 * intercept calls to createValueBinding() and createMethodBinding() for
 * certain kinds of expressions, but allow the existing application to
 * handle the rest.</p>
 */

public class ApplicationAssociate {

    protected final static Logger log = Logger.getLogger("strawberry.ApplicationAssociate");


    public String getHtml() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);

        pw.println("<pre>");

        printFactories(pw);

        pw.println("</pre>");

        pw.close();

        return sw.toString();
    }

    public void printFactories(PrintWriter pw) {

        Iterator it = managedBeanFactoriesMap.keySet().iterator();

        while (it.hasNext()) {
            String key = (String) it.next();
            ManagedBeanFactory val = (ManagedBeanFactory) managedBeanFactoriesMap.get(key);
            ManagedBeanBean bean = val.getManagedBeanBean();

            pw.println(key + ", " + val);
            printIt(pw, bean);
            pw.println("-----------");
        }
    }


    public void printIt(PrintWriter pw, ManagedBeanBean mb) {

        int i = 0;
        pw.println("" + i + ", getManagedBeanName: " + mb.getManagedBeanName());
        pw.println("" + i + ", getManagedBeanClass: " + mb.getManagedBeanClass());
        pw.println("" + i + ", getManagedBeanScope: " + mb.getManagedBeanScope());

        ManagedPropertyBean[] propArray = mb.getManagedProperties();
        for (int j = 0; j < propArray.length; j++) {
            ManagedPropertyBean pb = propArray[j];
            pw.println("" + i + ", ManagedPropertyBean.Name: " + pb.getPropertyName() +
                       ", Class: " + pb.getPropertyClass() +
                       ", Value: " + pb.getValue());
        }
        MapEntriesBean mapEnt =  mb.getMapEntries();
        if (mapEnt != null) printMapEntries(pw, mapEnt);

        ListEntriesBean listEnt = mb.getListEntries();
        if (listEnt != null) log.info("" + i + ", listEnt = " + listEnt);

    }

    private void printMapEntries(PrintWriter pw, MapEntriesBean mapEnt) {
        MapEntryBean[] beans = mapEnt.getMapEntries();
        for (int i = 0; i < beans.length; i++) {

            pw.println("?, " + i + ", " + beans[i].getKey() + " = " + beans[i].getValue());
        }
    }

  
    //
    // This map stores "managed bean name" | "managed bean factory"
    // mappings.
    //
    private Map managedBeanFactoriesMap = null;


    // Flag indicating that a response has been rendered.

    public static final String ASSOCIATE_KEY = "strawberry.ApplicationAssociate";    
    // ύX

    static int createdCount = 0;
  
    public ApplicationAssociate() {

        log.finest("ApplicationAssociate --------- RXgN^");
      
        managedBeanFactoriesMap = new HashMap();
    }
    
    public static ApplicationAssociate getInstance(Object arg) {

        if (log.isLoggable(Level.FINER))
            log.finer("205) ******* find ASSOCIATE_KEY = " + ASSOCIATE_KEY);
        if (arg == null) return null;
      
        ServletContext sc = null;
        if (arg instanceof ExternalContext) {
        // call from  com.sun.faces.el.VariableResolverImpl.resolveVariable(VariableResolverImpl.java:96)
            ExternalContext ec = (ExternalContext) arg;
            sc = (ServletContext) ec.getContext();
        } else if (arg instanceof ServletContext) {
        // call from com.sun.faces.application.ApplicationImpl(C)
            sc = (ServletContext) arg;
        } else {
            throw new IllegalArgumentException(arg.getClass().getName());
        }
      
        Object wk = sc.getAttribute(ASSOCIATE_KEY);
        if (log.isLoggable(Level.FINER))
            log.finer("************  => " + wk);
        return (ApplicationAssociate) wk;
    }
  
    public static void clearInstance(ExternalContext 
        externalContext) {
        Map applicationMap = externalContext.getApplicationMap();
	applicationMap.remove(ASSOCIATE_KEY);
    }

    

    /**
     * <p>Adds a new mapping of managed bean name to a managed bean
     * factory instance.</p>
     *
     * @param managedBeanName the name of the managed bean that will
     *                        be created by the managed bean factory instance.
     * @param factory         the managed bean factory instance.
     */
    synchronized public void addManagedBeanFactory(String managedBeanName,
                                                   ManagedBeanFactory factory) {
        managedBeanFactoriesMap.put(managedBeanName, factory);
	factory.setManagedBeanFactoryMap(managedBeanFactoriesMap);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Added managedBeanFactory " + factory + " for" +
                      managedBeanName);
        }
    }


    public int getManagedBeanFactoriesSize() {
      return managedBeanFactoriesMap.size();
    }



    /**
     * <p>The managedBeanFactories HashMap has been populated
     * with ManagedBeanFactory object keyed by the bean name.
     * Find the ManagedBeanFactory object and if it exists instantiate
     * the bean and store it in the appropriate scope, if any.</p>
     *
     * @param context         The Faces context.
     * @param managedBeanName The name identifying the managed bean.
     * @return The managed bean.
     * @throws FacesException if the managed bean
     *                                   could not be created.
     */
    public Object createAndMaybeStoreManagedBeans(FacesContext context,
                                                               String managedBeanName)
        throws FacesException {
        ManagedBeanFactory managedBean = (ManagedBeanFactory)
            managedBeanFactoriesMap.get(managedBeanName);
        if (managedBean == null) {
            if (log.isLoggable(Level.WARNING)) {
                log.warning("(224)Couldn't find a factory for " + managedBeanName + " ################");
            }
            return null;
        }
        
        Object bean = null;
        //add bean to appropriate scope
        String scope = managedBean.getScope();
        
        if (log.isLoggable(Level.FINE)) {
            log.fine("234) Storing " + managedBeanName + " in scope " + scope);
        }

	boolean 
	    scopeIsApplication = false,
	    scopeIsSession = false,
	    scopeIsRequest = false;
	
        if ((scopeIsApplication = 
	     scope.equalsIgnoreCase(RIConstants.APPLICATION))
	    ||
	    (scopeIsSession = scope.equalsIgnoreCase(RIConstants.SESSION))) {
	    synchronized (this) {
		try {
		    bean = managedBean.newInstance(context);
		    if (log.isLoggable(Level.FINE)) {
			log.fine("Created bean " + managedBeanName + " successfully ");
		    }
		} catch (Exception ex) {
		    Object[] params = {ex.getMessage()};
		    
			log.log(Level.SEVERE,"Managedbean " + managedBeanName + 
				  " could not be created " + ex.getMessage(), ex);
		     
		    throw new FacesException(ex);
		}
		if (scopeIsApplication) {
		    context.getExternalContext().
			getApplicationMap().put(managedBeanName, bean);
		}
		if (scopeIsSession) {
		    Util.getSessionMap(context).put(managedBeanName, bean);
		}
	    }
	}
	else {
	    scopeIsRequest = scope.equalsIgnoreCase(RIConstants.REQUEST);
	    try {
		bean = managedBean.newInstance(context);
		if (log.isLoggable(Level.FINE)) {
		    log.fine("Created bean " + managedBeanName + " successfully ");
		}
	    } catch (Exception ex) {
		Object[] params = {ex.getMessage()};
		
		    log.log(Level.SEVERE, "409) Managedbean " + managedBeanName + 
			      " could not be created " + ex.getMessage(), ex);
		 
		throw new FacesException(ex);
	    }
	    
	    if (scopeIsRequest) {
		context.getExternalContext().
		    getRequestMap().put(managedBeanName, bean);
	    }
	}
        return bean;
    }

}
