/*   -*- Mode: java4; -*-
 * Copyright (C)  2007 Masahito Henmi, All rights reserved.
 */
package strawberry;

import java.util.logging.Logger;
import javax.faces.context.ExternalContext;
/**
 * Created on 2007/06/14
 */
public class ViewIdUtil {

    protected final static Logger log = Logger.getLogger("strawberry.lifecycle");

    public static boolean isCustomizedViewId(ExternalContext external) {

        boolean b = _isCustomizedViewId( external);
        log.config("isCustomizedViewId => " + b);
        return b;
    }

    private static boolean _isCustomizedViewId(ExternalContext external) {
        String viewIdMode = external.getInitParameter(FaceletsConstants.PARAM_VIEWID_MODE);

        if (viewIdMode == null) return false;
        return "true".equalsIgnoreCase(viewIdMode);
    }


}
