/*
 * Copyright (C)  2007 Masahito Henmi, All rights reserved.
 */
package jsfutil.validator;

import com.sun.faces.util.MessageFactory;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import java.util.*;
import java.util.logging.*;
/**
 *  t̃v_EŖt͋֎~
 */

public class FutureValidator implements Validator, StateHolder {

  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.FutureValidator");
  
  // ------------------------------------------------------ Manifest Constants

  /**
   * <p>The standard converter id for this converter.</p>
   */
  public static final String VALIDATOR_ID = "jsfutil.validator.FutureValidator";


  /**
   * <p>The message identifier </p>
   */
  public static final String MAXIMUM_MESSAGE_ID = "jsfutil.validator.FutureValidator.MAXIMUM";



  // ------------------------------------------------------------ Constructors


  // -------------------------------------------------------------- Properties


  private int maximum = 0;
  private boolean maximumSet = false;


  /**
   * <p>Return the maximum length to be enforced by this {@link
   * Validator}, or <code>0</code> if the maximum has not been
   * set.</p>
   */
  public int getMaximum() {

    return (this.maximum);

  }


  /**
   * <p>Set the maximum length to be enforced by this {@link Validator}.</p>
   *
   * @param maximum The new maximum value
   *
   */
  public void setMaximum(int maximum) {

    this.maximum = maximum;
    this.maximumSet = true;
  }

  // ------------------------------------------------------- Validator Methods

  public Calendar getTodaysMidnight() {
    GregorianCalendar gc = new GregorianCalendar();
    // ́AbĂ̂ŁArŎsB
    //  GregorianCalendar ,bāANɂf[^
    int startYY = gc.get(Calendar.YEAR);
    int startMM = gc.get(Calendar.MONTH);
    int startDD = gc.get(Calendar.DAY_OF_MONTH);
    return new GregorianCalendar(startYY, startMM, startDD);
  }



  
  /**
   * @exception NullPointerException {@inheritDoc}
   * @exception ValidatorException {@inheritDoc}
   */
  public void validate(FacesContext context,
                       UIComponent  component,
                       Object       value) throws ValidatorException {

    if ((context == null) || (component == null)) {
      throw new NullPointerException();
    }
    if (value != null) {
      
      log.info("value = " + value + ", " + value.getClass().getName());

      Calendar today = getTodaysMidnight();
      
      checkFuture(value, today);

      /*
      String converted = stringValue(value);
      if (maximumSet &&
          (converted.length() > maximum)) {
        throw new ValidatorException(MessageFactory.getMessage
                                     (context,
                                      MAXIMUM_MESSAGE_ID,
                                      new Object[] {
                                        integerToString(component,
                                                        new Integer(maximum)) } ));
       */
      }
    }

  public void checkFuture(final Object value, Calendar today) throws ValidatorException {


    if (value instanceof java.sql.Date) {
      java.sql.Date input = (java.sql.Date) value;
      long inputTime = input.getTime();
      
      long todayTime = today.getTimeInMillis();
      if (todayTime <= inputTime) {
        throw new ValidatorException(new FacesMessage("tĂ܂"));
      }
    }
    
    if (value instanceof Calendar) {

      Calendar inputValue = (Calendar) value;

      if (! today.after(inputValue)) {
        throw new ValidatorException(new FacesMessage("tĂ܂"));
      }
    }
  }

  


  public boolean equals(Object otherObj) {

    if (!(otherObj instanceof FutureValidator)) {
      return false;
    }
    return true;
  }


  // -------------------------------------------------------- Private Methods


  // ----------------------------------------------------- StateHolder Methods


  public Object saveState(FacesContext context) {

    Object values[] = new Object[4];
//    values[0] = new Integer(maximum);
//    values[1] = maximumSet ? Boolean.TRUE : Boolean.FALSE;
//    values[2] = new Integer(minimum);
//    values[3] = minimumSet ? Boolean.TRUE : Boolean.FALSE;
    return (values);

  }


  public void restoreState(FacesContext context, Object state) {

    Object values[] = (Object[]) state;
//    maximum = ((Integer) values[0]).intValue();
//    maximumSet = ((Boolean) values[1]).booleanValue();
//    minimum = ((Integer) values[2]).intValue();
//    minimumSet = ((Boolean) values[3]).booleanValue();
  }


  private boolean transientValue = true;


  public boolean isTransient() {

    return (this.transientValue);
  }


  public void setTransient(boolean transientValue) {

    this.transientValue = transientValue;
  }
}
