/*  -*- Mode: java4; -*-
 * $Id: FacesContextImpl.java,v 1.66.30.2.2.1 2006/04/12 19:32:05 ofung Exp $
 */

/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at
 * https://javaserverfaces.dev.java.net/CDDL.html or
 * legal/CDDLv1.0.txt. 
 * See the License for the specific language governing
 * permission and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at legal/CDDLv1.0.txt.    
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * 
 * 
 * "Portions Copyrighted [2007] [MASAHITO HENMI]"
 * 
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.faces.context;

import com.sun.faces.util.Util;
import org.apache.commons.collections.CursorableLinkedList;

import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.FacesMessage;
import javax.faces.application.FacesMessage.Severity;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.event.FacesEvent;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import java.util.logging.*;

// 2007.2.26
import javax.el.ELContext;

public class FacesContextImpl extends FacesContext {

    // jdk1.4 logging
    protected final static Logger log = Logger.getLogger("strawberry.ctx.faces");
    protected final static Logger logRen = Logger.getLogger("strawberry.ren");
                 //  getRenderKit
    protected final static Logger lifecycleLog   = Logger.getLogger("strawberry.lifecycle");
    //
    // Instance Variables
    //
    private boolean released;

    // Relationship Instance Variables
    private ResponseStream responseStream = null;
    private ResponseWriter responseWriter = null;
    private CursorableLinkedList facesEvents = null;
    private ExternalContext externalContext = null;
    private Application application = null;
    private UIViewRoot viewRoot = null;
    private RenderKitFactory rkFactory;
    private RenderKit lastRk;
    private String lastRkId;

    /**
     * Store mapping of clientId to ArrayList of FacesMessage
     * instances.  The null key is used to represent FacesMessage instances
     * that are not associated with a clientId instance.
     */
    private Map componentMessageLists;       

    
    
    // Attribute Instance Variables

    private boolean renderResponse = false;
    private boolean responseComplete = false;


    //
    // Constructors and Initializers    
    // 
    public FacesContextImpl() {
    }

    public FacesContextImpl(ExternalContext ec, RenderKitFactory rkf, Application app) {
        if (null == ec ) {
            throw new NullPointerException(
                    Util.getExceptionMessageString(
                        Util.NULL_PARAMETERS_ERROR_MESSAGE_ID));
        }
        this.externalContext = ec;
        setCurrentInstance(this);
        
        rkFactory = rkf;
        application = app;
    }
    
    public void setRenderKitFactory(RenderKitFactory newValue) {
      rkFactory = newValue;
    }

    public RenderKitFactory getRenderKitFactory() {
      return rkFactory;
    }

    //
    // Class methods
    //

    //
    // General Methods
    
    //
    //
    // Methods from FacesContext
    //

    /** FacesContext ̎ */
    public ExternalContext getExternalContext() {
        assertNotReleased();
        return externalContext;
    }


    /**
     * <p>Return the {@link Application} instance associated with this
     * web application.</p>
    * FacesContext ̎ 
     */
    public Application getApplication() {
        assertNotReleased();
        if (null != application) {
            return application;
        }
        return application;
    }
    public void setApplication(Application newValue) {
      application = newValue;
    }


    /** FacesContext ̎ */
    public Iterator getClientIdsWithMessages() {
        assertNotReleased();
        Iterator result = null;
        if (null == componentMessageLists) {
            result = Collections.EMPTY_LIST.iterator();
        } else {
            result = componentMessageLists.keySet().iterator();

        }
        return result;
    }


    public Iterator getFacesEvents() {
        assertNotReleased();
        if (facesEvents != null) {
            return (facesEvents.cursor());
        } else {
            return (Collections.EMPTY_LIST.iterator());
        }
    }


    /** FacesContext ̎ */
    public Severity getMaximumSeverity() {
        assertNotReleased();
        int max = 0;
        Severity result = null;

        if (null == componentMessageLists) {
            return null;
        }
        // Get an Iterator over the ArrayList instances
        List messages = getMergedMessageLists();
        for (int i = 0, size = getMergedMessageLists().size(); i < size; i++) {
            result = ((FacesMessage) messages.get(i)).getSeverity();
            if (result.getOrdinal() > max) {
                max = result.getOrdinal();
            }

            if (result == FacesMessage.SEVERITY_FATAL) {
                break;
            }
        }
        return result;
    }


    /** FacesContext ̎ */
    public Iterator getMessages() {
        assertNotReleased();
        if (null == componentMessageLists) {
            return (Collections.EMPTY_LIST.iterator());
        }

        // Get an Iterator over the ArrayList instances
        List messages = getMergedMessageLists();
        if (messages.size() > 0) {
            return messages.iterator();
        } else {
            return Collections.EMPTY_LIST.iterator();
        }
    }


    /** FacesContext ̎ */
    public Iterator getMessages(String clientId) {
        assertNotReleased();
        // If no messages have been enqueued at all,
        // return an empty List Iterator
        if (null == componentMessageLists) {
            return (Collections.EMPTY_LIST.iterator());
        }

        List list = (List) componentMessageLists.get(clientId);
        if (list == null) {
            return (Collections.EMPTY_LIST.iterator());
        }
        return (list.iterator());
    }


    /** FacesContext ̎ */
    public RenderKit getRenderKit() {
        assertNotReleased();
        UIViewRoot vr = getViewRoot();
        if (vr == null) {
            log.fine("235) return null");
            return (null);
        }
        String renderKitId = vr.getRenderKitId();
        if (renderKitId == null) {
            log.severe("240) UIViewRoot.getRenderKitId() == null Ȃ̂ŁARenderKit쐬ł܂  ");

            throw new NullPointerException(); // 2007.5.20
            //return null;
        }          
        
        if (renderKitId.equals(lastRkId)) {
            log.finer("245) return lastRk");
            return lastRk;
        } else {
            log.fine("248) return getRenderKit(" + renderKitId + ")");
            lastRk = rkFactory.getRenderKit(this, renderKitId);
            lastRkId = renderKitId;
            return lastRk;
        }
                                      
    }


    /** FacesContext ̎ */
    public ResponseStream getResponseStream() {
        assertNotReleased();
        return responseStream;
    }


    /** FacesContext ̎ */
    public void setResponseStream(ResponseStream newResponseStream) {
        assertNotReleased();
        if (newResponseStream == null) {
            throw new NullPointerException(
                Util.getExceptionMessageString(
                    Util.NULL_RESPONSE_STREAM_ERROR_MESSAGE_ID));
        }
        responseStream = newResponseStream;
    }


    /** FacesContext ̎ */
    public UIViewRoot getViewRoot() {
        assertNotReleased();
        return viewRoot;
    }


    /** FacesContext ̎ */
    public void setViewRoot(UIViewRoot root) {
        assertNotReleased();
                
        if (root == null) {
            throw new NullPointerException
                (Util.getExceptionMessageString(
                    Util.NULL_PARAMETERS_ERROR_MESSAGE_ID));
        }
        
        if (viewRoot != root) {
            facesEvents = null;
        }
        viewRoot = root;
    }


    /** FacesContext ̎ */
    public ResponseWriter getResponseWriter() {
        assertNotReleased();
     //   log.info("getResponseWriter => " + _print(responseWriter));
        return responseWriter;
    }

    private String _print(ResponseWriter rw) {
        return rw.getClass().getName() + "@" + Integer.toHexString(rw.hashCode());
    }

    

    /** FacesContext ̎ */
    public void setResponseWriter(ResponseWriter newResponseWriter) {
        assertNotReleased();
        if (newResponseWriter == null) {
            throw new NullPointerException(
                Util.getExceptionMessageString(
                    Util.NULL_RESPONSE_WRITER_ERROR_MESSAGE_ID));
        }
        log.info("setResponseWriter <= " + _print(newResponseWriter));
        responseWriter = newResponseWriter;
    }


    public void addFacesEvent(FacesEvent event) {
        assertNotReleased();
        // Validate our preconditions
        if (event == null) {
            throw new NullPointerException
                (Util.getExceptionMessageString(Util.NULL_EVENT_ERROR_MESSAGE_ID));
        }

        // Add this event to our internal queue
        if (facesEvents == null) {
            facesEvents = new CursorableLinkedList();
            log.info("--------------------- commons.collection ̋@\g܂");
        }
        facesEvents.add(event);
        if (log.isLoggable(Level.FINE)) {
            String id = event.getComponent().getId();
            if (id == null) {
                id = "<<NONE>>";
            }
            log.fine("Adding FacesEvent[sourceId=" + id +
                      ",type=" + event.getClass().getName());
        }

    }


    /** FacesContext ̎ */
    public void addMessage(String clientId, FacesMessage message) {
        assertNotReleased();
        // Validate our preconditions
        if (null == message) {
            throw new NullPointerException
                (
                    Util.getExceptionMessageString(
                        Util.NULL_PARAMETERS_ERROR_MESSAGE_ID));
        }

        if (componentMessageLists == null) {
            componentMessageLists = new HashMap();
        }

        // Add this message to our internal queue
        List list = (List) componentMessageLists.get(clientId);
        if (list == null) {
            list = new ArrayList();
            componentMessageLists.put(clientId, list);
        }
        list.add(message);

        if (log.isLoggable(Level.FINE)) {
            log.fine("Adding Message[sourceId=" +
                      (clientId != null ? clientId : "<<NONE>>") +
                      ",summary=" + message.getSummary() + ")");
        }

    }


    /** FacesContext ̎ */
    public void release() {
        released = true;
        externalContext = null;
        responseStream = null;
        responseWriter = null;
        facesEvents = null;
        componentMessageLists = null;
        renderResponse = false;
        responseComplete = false;
        viewRoot = null;

        elContext = null; //add
      
        // PENDING(edburns): write testcase that verifies that release
        // actually works.  This will be important to keep working as
        // ivars are added and removed on this class over time.

        // Make sure to clear our ThreadLocal instance.
        setCurrentInstance(null);
    }


    /** FacesContext ̎ */
    public void renderResponse() {

        lifecycleLog.fine("responseComplete called ------------------- **");
        assertNotReleased();
        renderResponse = true;
    }


    /** FacesContext ̎ */
    public void responseComplete() {

        lifecycleLog.fine("responseComplete called ------------------- **");
        assertNotReleased();
        responseComplete = true;
    }


    /** FacesContext ̎ */
    public boolean getRenderResponse() {
        assertNotReleased();
        return renderResponse;
    }


    /** FacesContext ̎ */
    public boolean getResponseComplete() {
        assertNotReleased();
        return responseComplete;
    }


    //
    // Private methods
    //
    private void assertNotReleased() {
        if (released) {
            throw new IllegalStateException();
        }
    }


    private List getMergedMessageLists() {
        List mergedList = new ArrayList();
        if (componentMessageLists != null) {
            for (Iterator i = componentMessageLists.values().iterator(); i.hasNext();) {
                for (Iterator ii = ((ArrayList) i.next()).iterator(); ii.hasNext();)
                    mergedList.add(ii.next());
            }
        }
        return mergedList;
    }
   
    // The testcase for this class is TestFacesContextImpl.java 
    // The testcase for this class is TestFacesContextImpl_Model.java

     private ELContext elContext = null;

     public ELContext getELContext() {
         assertNotReleased();
         if (elContext == null) {
/*             elContext = new ELContextImpl(getApplication().getELResolver());
             elContext.putContext(FacesContext.class, this);
             UIViewRoot root = this.getViewRoot();
             if (null != root) {
                 elContext.setLocale(root.getLocale());
             }*/
         }
         return elContext;
     }

     public void setELContext(ELContext elc) {
       elContext = elc;
     }
} // end of class FacesContextImpl
