/*
 * Copyright (C)  2007 Masahito Henmi, All rights reserved.
 */
package strawberry.script;

import strawberry.plugin.ScriptEngine;
import FESI.jslib.*;
import java.util.logging.*;
import javax.faces.FacesException;
/**
 * Created on 2007/05/07
 */
public class FesiEngineImpl extends ScriptEngine {

  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.script");

  boolean bInitialized = false;

  // The evaluator
  JSGlobalObject global = null;


  public void addScriptableObject(String name, Object obj) {

    initIfNecessary();
    try {
      global.setMember(name, obj);
    } catch (JSException e) {
      throw new RuntimeException(e);
    }
  }

  public Object evaluateString(String source, String sourceName, int lineNum) {

    initIfNecessary();
    Object securytyDomain = null;
    log.info("source = " + source);
    log.info("global = " + global.getClass().getName()); //FESI.Data.JSGlobalWrapper

    Object result = null;
    try {
      result = global.eval(source); // Basic evaluation
    } catch (JSException e) {
/*
      Throwable oe = e.getOriginatingException();
      if (oe != null) {
        oe.printStackTrace();
      } else {
        e.printStackTrace();
      }

      throw new RuntimeException(e);
  */
      throw new FacesException(e.getMessage()); // TODO ScriptException
    }

    log.info("result = " + result);
    return result;
  }


  String[] extensions = new String[] {"FESI.Extensions.BasicIO",
    "FESI.Extensions.JavaAccess",
    "FESI.Extensions.FileIO"};

  public void initIfNecessary() {
    if (bInitialized == false) {

      try {
        global = JSUtil.makeEvaluator(extensions);

      } catch (JSException e) {
        e.printStackTrace();
        throw new RuntimeException(e);
      }

      bInitialized = true;
    }
  }


  public void release() {

    log.info("release Ă΂܂");
    if (bInitialized) {
      //Context.exit();
    }
  }
}
