// FunctionEvaluationSource.java
// FESI Copyright (c) Jean-Marc Lugrin, 1999
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.

// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

package FESI.Interpreter;

/**
 * Describe a function used as a source.
 */

public class FunctionEvaluationSource extends EvaluationSource {
    
    private String theFunctionName;
    
    /**
     * Create a function source description
     * @param evaluationSource Describe the function name
     * @param previousSource Describe the calling source
     */
    public FunctionEvaluationSource(
            EvaluationSource evaluationSource,
            String theFunctionName) {
        super(evaluationSource);
        this.theFunctionName = theFunctionName;
    }
    protected String getEvaluationSourceText() {
        return "of function '" + theFunctionName +"' " +
            previousSource.getEvaluationSourceText();
    }
}