/* Generated By:JJTree: Do not edit this line. SimpleNode.java */

package FESI.AST;

import FESI.Exceptions.ProgrammingError;
import FESI.Parser.EcmaScript;
import FESI.Parser.EcmaScriptConstants;

public abstract class SimpleNode implements Node, EcmaScriptConstants {
  protected Node parent;
  protected Node[] children;
  protected int id;
  protected EcmaScript parser;
  protected int line = 0;        // JMCL
  
  public SimpleNode(int i) {
    id = i;
  }

  public SimpleNode(EcmaScript p, int i) {
    this(i);
    parser = p;
  }

  public void jjtOpen() {
  }

  public void jjtClose() {
  }
  
  public void jjtSetParent(Node n) { parent = n; }
  public Node jjtGetParent() { return parent; }

  public void jjtAddChild(Node n, int i) {
    if (children == null) {
      children = new Node[i + 1];
    } else if (i >= children.length) {
      Node c[] = new Node[i + 1];
      System.arraycopy(children, 0, c, 0, children.length);
      children = c;
    }
    children[i] = n;
  }

  public Node jjtGetChild(int i) {
    return children[i];
  }

  public int jjtGetNumChildren() {
    return (children == null) ? 0 : children.length;
  }

  /** Accept the visitor. **/
  public Object jjtAccept(EcmaScriptVisitor visitor, Object data) {
    return visitor.visit(this, data);
  }

  /** Accept the visitor. **/
  public Object childrenAccept(EcmaScriptVisitor visitor, Object data) {
    if (children != null) {
      for (int i = 0; i < children.length; ++i) {
        children[i].jjtAccept(visitor, data);
      }
    }
    return data;
  }

  /* You can override these two methods in subclasses of SimpleNode to
     customize the way the node appears when the tree is dumped.  If
     your output uses more than one line you should override
     toString(String), otherwise overriding toString() is probably all
     you need to do. */

  // JMCL
  public String toString() { 
     return EcmaScriptTreeConstants.jjtNodeName[id]; 
  }
  public String toString(String prefix) { return prefix + toString(); }

  /* Override this method if you want to customize how the node dumps
     out its children. */

  public void dump(String prefix) {
    System.out.println(toString(prefix));
    if (children != null) {
      for (int i = 0; i < children.length; ++i) {
	SimpleNode n = (SimpleNode)children[i];
	if (n != null) {
	  n.dump(prefix + " ");
	}
      }
    }
  }
  
  // JMCL
  public void setLineNumber(int line) {
      this.line = line;
  }
  
  public int getLineNumber() {
      return line;
  }

  public void assertNoChildren() {
      if (jjtGetNumChildren()>0) {
          throw new ProgrammingError("AST Should have no children");
      }
  }
  public void assertOneChild() {
      if (jjtGetNumChildren()!=1) {
          throw new ProgrammingError("AST Should have 1 child");
      }
  }
  public void assertTwoChildren() {
      if (jjtGetNumChildren()!=2) {
          throw new ProgrammingError("AST Should have 2 children");
      }
  }
  public void assertThreeChildren() {
      if (jjtGetNumChildren()!=3) {
          throw new ProgrammingError("AST Should have 3 children");
      }
  }
  public void assertFourChildren() {
      if (jjtGetNumChildren()!=4) {
          throw new ProgrammingError("AST Should have 4 children");
      }
  }
  
}