/* Generated By:JJTree: Do not edit this line. ASTLiteral.java */

package FESI.AST;

import FESI.Data.ESBoolean;
import FESI.Data.ESNull;
import FESI.Data.ESUndefined;
import FESI.Data.ESNumber;
import FESI.Data.ESString;
import FESI.Data.ESValue;
import FESI.Exceptions.ProgrammingError;
import FESI.Parser.EcmaScript;


public class ASTLiteral extends SimpleNode {

  private ESValue theValue = null;

  public ASTLiteral(int id) {
    super(id);
  }

  public ASTLiteral(EcmaScript p, int id) {
    super(p, id);
  }

  public static Node jjtCreate(int id) {
      return new ASTLiteral(id);
  }

  public static Node jjtCreate(EcmaScript p, int id) {
      return new ASTLiteral(p, id);
  }

  /** Accept the visitor. **/
  public Object jjtAccept(EcmaScriptVisitor visitor, Object data) {
    return visitor.visit(this, data);
  }
  
  // JMCL
  public ESValue getValue() {
      return theValue;
  }

  static final int hexval(char c) throws ProgrammingError {
    switch(c)
    {
       case '0' :
          return 0;
       case '1' :
          return 1;
       case '2' :
          return 2;
       case '3' :
          return 3;
       case '4' :
          return 4;
       case '5' :
          return 5;
       case '6' :
          return 6;
       case '7' :
          return 7;
       case '8' :
          return 8;
       case '9' :
          return 9;

       case 'a' :
       case 'A' :
          return 10;
       case 'b' :
       case 'B' :
          return 11;
       case 'c' :
       case 'C' :
          return 12;
       case 'd' :
       case 'D' :
          return 13;
       case 'e' :
       case 'E' :
          return 14;
       case 'f' :
       case 'F' :
          return 15;
    }

    throw new ProgrammingError("Illegal hex or unicode constant"); // Should never come here
  }
  static final int octval(char c) throws ProgrammingError {
    switch(c)
    {
       case '0' :
          return 0;
       case '1' :
          return 1;
       case '2' :
          return 2;
       case '3' :
          return 3;
       case '4' :
          return 4;
       case '5' :
          return 5;
       case '6' :
          return 6;
       case '7' :
          return 7;
       case '8' :
          return 8;
       case '9' :
          return 9;

       case 'a' :
       case 'A' :
          return 10;
       case 'b' :
       case 'B' :
          return 11;
       case 'c' :
       case 'C' :
          return 12;
       case 'd' :
       case 'D' :
          return 13;
       case 'e' :
       case 'E' :
          return 14;
       case 'f' :
       case 'F' :
          return 15;
    }

    throw new ProgrammingError("Illegal octal constant"); // Should never come here
  }
  
  public void setStringValue(String image) {
        int l = image.length();
        StringBuffer sb = new StringBuffer(l);
        for (int i=0; i<l; i++) {
            char c = image.charAt(i);
            if ((c == '\\') && (i+1<l)){
                i++;
                c = image.charAt(i);
                if (c=='n') c='\n';
                else if (c=='b') c = '\b';
                else if (c=='f') c = '\f';
                else if (c=='r') c = '\r';
                else if (c=='t') c = '\t';
                else if (c =='x') {
                   c = (char)(hexval(image.charAt(i+1)) << 4 |
                                       hexval(image.charAt(i+1)));
                   i +=2;
               } else if (c =='u') {
                   c = (char)(hexval(image.charAt(i+1)) << 12 |
                                       hexval(image.charAt(i+2)) << 8 |
                                       hexval(image.charAt(i+3)) << 4 |
                                       hexval(image.charAt(i+4)));
                   i +=4;
               } else if (c >='0' && c <= '7') {
                   c = (char)(octval(image.charAt(i)));
                   if ((image.length()>i) && 
                           (image.charAt(i+1)>='0') && (image.charAt(i+1)<='7')) {
                      i++;
                      c = (char) ((c<<4) | octval(image.charAt(i)));
                   }
               }
            }
            sb.append(c);
        }
        theValue = new ESString(sb.toString());
  }
  public void setDecimalValue(String image) {
      try {
        theValue = new ESNumber(Long.parseLong(image));
     } catch (NumberFormatException e) {
         Double value = new Double(image);
         theValue = new ESNumber(value.doubleValue());
     }
  }
  public void setOctalValue(String image) {
      try {
        String imageWithout0 = image.substring(1);          
        theValue = new ESNumber(Long.parseLong(imageWithout0,8));
     } catch (NumberFormatException e) {
         Double value = new Double(image);
         theValue = new ESNumber(value.doubleValue());
     }
  }
  public void setHexValue(String image) {
      try {
        String imageWithout0x = image.substring(2);
        theValue = new ESNumber(Long.parseLong(imageWithout0x,16));
     } catch (NumberFormatException e) {
         Double value = new Double(image);
         theValue = new ESNumber(value.doubleValue());
     }
  }
  public void setFloatingPointValue(String image) {
        Double value = new Double(image);
        theValue = new ESNumber(value.doubleValue());
  }
  public void setBooleanValue(boolean value) {
        theValue = ESBoolean.makeBoolean(value);
  }
  public void setNullValue() {
        theValue = ESNull.theNull;
  }
  public void setUndefinedValue() {
        theValue = ESUndefined.theUndefined;
  }
  
  public String toString() {
      return "[" + theValue.toString() + "]";
  }

}