/*  -*- Mode: java4; -*-
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 * 
 * "Portions Copyrighted [2007] [MASAHITO HENMI]"
 * 
 * 
 */

package org.apache.el.lang;

import java.lang.reflect.Method;

import javax.el.FunctionMapper;
import java.util.logging.*;
/**
 * @author Jacob Hookom [jacob@hookom.net]
 * @version $Change: 181177 $$DateTime: 2001/06/26 08:45:09 $$Author: markt $
 */
public class FunctionMapperFactory extends FunctionMapper {

    // jdk1.4 logging
    protected final static Logger log = Logger.getLogger("strawberry.el.funmap");
  
    protected FunctionMapperImpl memento = null;
    protected FunctionMapper target;
    /*
        at org.apache.el.lang.FunctionMapperFactory.<init>(FunctionMapperFactory.java:44)
        at org.apache.el.lang.ExpressionBuilder.<init>(ExpressionBuilder.java:82)
        at org.apache.el.ExpressionFactoryImpl.createValueExpression(ExpressionFactoryImpl.java:67)
        at com.sun.facelets.el.ELText$ELTextVariable.apply(ELText.java:161)
        at com.sun.facelets.el.ELText$ELTextComposite.apply(ELText.java:142)
        at com.sun.facelets.compiler.TextInstruction.apply(TextInstruction.java:56)
        at com.sun.facelets.compiler.UIInstructionHandler.apply(UIInstructionHandler.java:84)
        at com.sun.facelets.compiler.NamespaceHandler.apply(NamespaceHandler.java:67)
*/
    public FunctionMapperFactory(FunctionMapper mapper) {
        
        if (mapper == null) {
            throw new NullPointerException("FunctionMapper target cannot be null");
        }
        this.target = mapper;
        
        if (log.isLoggable(Level.FINE)) {
            log.fine("RXgN^:  FunctionMapper = " + mapper);
            log.fine("RXgN^: this = " + Integer.toHexString(this.hashCode()) );
        }
    }

    /*
javax.el.ELException: 
        at org.apache.el.lang.ExpressionBuilder.prepare(ExpressionBuilder.java:166)
        at org.apache.el.lang.ExpressionBuilder.build(ExpressionBuilder.java:178)
        at org.apache.el.lang.ExpressionBuilder.createValueExpression(ExpressionBuilder.java:222)
        at org.apache.el.ExpressionFactoryImpl.createValueExpression(ExpressionFactoryImpl.java:84)
        at com.sun.facelets.el.ELText$ELTextVariable.apply(ELText.java:176)
        at com.sun.facelets.el.ELText$ELTextComposite.apply(ELText.java:149)
        at com.sun.facelets.compiler.TextInstruction.apply(TextInstruction.java:56)
        at com.sun.facelets.compiler.UIInstructionHandler.apply(UIInstructionHandler.java:84)
        at com.sun.facelets.compiler.NamespaceHandler.apply(NamespaceHandler.java:67)

      Caused by:                                      

        at org.apache.el.lang.FunctionMapperFactory.resolveFunction(FunctionMapperFactory.java:80)
        at org.apache.el.lang.ExpressionBuilder.visit(ExpressionBuilder.java:199)
        at org.apache.el.parser.SimpleNode.accept(SimpleNode.java:129)
        at org.apache.el.lang.ExpressionBuilder.prepare(ExpressionBuilder.java:160)


    
     *    d:addTableName ̏ꍇ
     *    prefix = "d",  localName ="addTableName" ł
     */
    public Method resolveFunction(String prefix, String localName) {

        log.fine("resolveFunction() ---------܂ ");

        // Vapache FunctionMapperImpl쐬A
        //
        //  target  resolveFunction(prefix, localName)\bh
        //  PAaddFunctionœo^
        
        if (this.memento == null) {
            //  apache  FunctionMapperImpl 𐶐
            this.memento = new FunctionMapperImpl();
            if (log.isLoggable(Level.FINE)) log.fine("68) V쐬 funcMap = " + memento);
        }

        if (log.isLoggable(Level.FINE)) {
          log.fine("72) this = " + Integer.toHexString(this.hashCode()) );
          log.fine("73)  target = " + target); //com.sun.facelets.el.CompositeFunctionMapper
          log.fine("74) prefix = " + prefix + ", localName = " + localName);
        }
        
        Method m = this.target.resolveFunction(prefix, localName);
        if (m != null) {
            log.fine("105)  addFunction()   Methodo^ ܂--------------");
            this.memento.addFunction(prefix, localName, m);
        }
        return m;
    }
    
    public FunctionMapper create() {
        if (log.isLoggable(Level.FINE)) {
          log.fine("113) create() ---------܂ ");
          log.fine("114) this = " + Integer.toHexString(this.hashCode()) );
          log.fine("115) createƂOłAresolveFunction ō쐬cԂ܂");
        }
        return this.memento;
    }

}
