/*  -*- Mode: java4; -*-
 * Licensed under the Common Development and Distribution License,
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *   http://www.sun.com/cddl/
 *   
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or 
 * implied. See the License for the specific language governing
 * permissions and limitations under the License.
 *
 *
 * "Portions Copyrighted [2007] [MASAHITO HENMI]"
 */

package com.sun.facelets.tag.jstl.core;

import java.io.IOException;

import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagHandler;
import java.util.logging.*;

/**
 * @author Jacob Hookom
 * @version $Id: IfHandler.java,v 1.4 2005/08/24 04:38:52 jhook Exp $
 */
public final class IfHandler extends TagHandler {

    // jdk1.4 logging
    protected final static Logger log = Logger.getLogger("strawberry.fls.viewhandler");

  
    private final TagAttribute test;

    private final TagAttribute var;

    /**
     * @param config
     */
    public IfHandler(TagConfig config) {
        super(config);
        this.test = this.getRequiredAttribute("test");
        this.var = this.getAttribute("var");
    }

    public void apply(FaceletContext ctx, UIComponent parent)
            throws IOException, FacesException, ELException {
        

        log.fine("test.getLocalName = " + test.getLocalName());
        log.fine("test.getNamespace = " + test.getNamespace());
        log.fine("test.getQName = " + test.getQName());
        log.fine("test.getValue = " + test.getValue());


        boolean b = this.test.getBoolean(ctx);
        if (this.var != null) {
            ctx.setAttribute(var.getValue(ctx), new Boolean(b));
        }
        if (b) {
            this.nextHandler.apply(ctx, parent);
        }
    }

}
