// -*- Mode: java4; -*-
/**
 * Licensed under the Common Development and Distribution License,
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *   http://www.sun.com/cddl/
 *   
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or 
 * implied. See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * "Portions Copyrighted [2007] [MASAHITO HENMI]"
 *
 */
package com.sun.facelets.impl;

import java.io.IOException;
import java.net.URL;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import com.sun.facelets.util.Resource;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultResourceResolver implements ResourceResolver {

  
  protected final static Logger log = Logger.getLogger("facelets.DefaultResourceResolver");

  
    public DefaultResourceResolver() {
        super();
    }

    public URL resolveUrl(String path) {
        try {

          log.info("25 ----------------------------------  '" + path + "'");
          
            return Resource.getResourceUrl(FacesContext.getCurrentInstance(),
                    path);
        } catch (IOException e) {
            throw new FacesException(e);
        }
    }

    public String toString() {
        return "DefaultResourceResolver";
    }

}
