/**  -*- Mode: java4; -*-
 * Licensed under the Common Development and Distribution License,
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *   http://www.sun.com/cddl/
 *   
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or 
 * implied. See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * "Portions Copyrighted [2007] [MASAHITO HENMI]"
 *
 */

package com.sun.facelets.el;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

import javax.el.ELContext;
import javax.el.ELException;
import javax.el.PropertyNotWritableException;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.ValueBinding;

import java.util.logging.*;
import com.sun.facelets.el.TagValueExpression;
/**
 * @author Jacob Hookom
 * @version $Id: LegacyValueBinding.java,v 1.5 2005/08/24 04:38:57 jhook Exp $
 * 
 */
public final class LegacyValueBinding extends ValueBinding implements Externalizable {

    // jdk1.4 logging
    protected final static Logger elLog = Logger.getLogger("strawberry.el.variable");

    protected final static Logger log = Logger.getLogger("strawberry.el.funmap");
    protected final static Logger saveLog = Logger.getLogger("strawberry.state.save");
    protected final static Logger restoreLog = Logger.getLogger("strawberry.state.restore");
    
    static final long serialVersionUID = 5372799367653684839L;
    
    private ValueExpression delegate;
    
    public LegacyValueBinding() {
        super();
    }

    /** RXgN^ */
    public LegacyValueBinding(ValueExpression ve) {

        if (elLog.isLoggable(Level.FINE))
            elLog.fine("RXgN^" + ve);
        
        this.delegate = ve;
    }

    public Object getValue(FacesContext context) throws EvaluationException,
                                                        PropertyNotFoundException {

        ELContext ctx = ELAdaptor.getELContext(context);
        if (elLog.isLoggable(Level.FINE)) {
                elLog.fine("68) getValue ctx = " + ctx  );
                elLog.fine("69) getValue " + delegate.getClass().getName() );
        }
        try {
            
            return this.delegate.getValue(ctx);
        } catch (javax.el.PropertyNotFoundException e) {
            throw new PropertyNotFoundException(e.getMessage(), e.getCause());
        } catch (ELException e) {
            throw new EvaluationException(e.getMessage(), e.getCause());
        }
    }

    public void setValue(FacesContext context, Object value) throws EvaluationException,
                                                                    PropertyNotFoundException {
        
        ELContext ctx = ELAdaptor.getELContext(context);
        if (elLog.isLoggable(Level.FINE)) {
                elLog.fine("87) setValue ctx = " + ctx  );
                elLog.fine("88) setValue " + value );
        }
        try {
            this.delegate.setValue(ctx, value);
        } catch (PropertyNotWritableException e) {
            throw new PropertyNotFoundException(e.getMessage(), e.getCause());
        } catch (javax.el.PropertyNotFoundException e) {
            throw new PropertyNotFoundException(e.getMessage(), e.getCause());
        } catch (ELException e) {
            throw new EvaluationException(e.getMessage(), e.getCause());
        }
    }

    public boolean isReadOnly(FacesContext context) throws EvaluationException,
                                                           PropertyNotFoundException {
        ELContext ctx = ELAdaptor.getELContext(context);
        try {
            return this.delegate.isReadOnly(ctx);
        } catch (javax.el.PropertyNotFoundException e) {
            throw new PropertyNotFoundException(e.getMessage(), e.getCause());
        } catch (ELException e) {
            throw new EvaluationException(e.getMessage(), e.getCause());
        }
    }

    public Class getType(FacesContext context) throws EvaluationException,
                                                      PropertyNotFoundException {
        ELContext ctx = ELAdaptor.getELContext(context);
        try {
            return this.delegate.getType(ctx);
        } catch (javax.el.PropertyNotFoundException e) {

            log.log(Level.WARNING, " 102 ---------------------", e);
            
            throw new PropertyNotFoundException(e.getMessage(), e.getCause());
        } catch (ELException e) {
            throw new EvaluationException(e.getMessage(), e.getCause());
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (restoreLog.isLoggable(Level.FINE)) {
            if (delegate == null) {
              restoreLog.fine("113) start: delegate == null");
            } else {
              restoreLog.fine("116) start:" + delegate.getClass().getName());
            }
        }
        this.delegate = (ValueExpression) in.readObject();
        restoreLog.fine("120) end");
    }
    

    public void writeExternal(ObjectOutput out) throws IOException {
        if (saveLog.isLoggable(Level.FINE))
            saveLog.fine("126) start:" + delegate.getClass().getName());
        //           start:com.sun.facelets.el.TagValueExpression

        // VACYEoCg팸
        if (delegate instanceof TagValueExpression) {
            TagValueExpression tve = (TagValueExpression) delegate;
            
            out.writeObject(tve.getOrig());
        } else {
          out.writeObject(this.delegate);
        }
        saveLog.fine("129) end:");
    }

    public String getExpressionString() {
        return this.delegate.getExpressionString();
    }

    // ǉ
    public String getDebugString() {
        if (delegate instanceof TagValueExpression) {
            TagValueExpression tve = (TagValueExpression) delegate;
            return "LegacyVB[" + tve.getDebugString() + "]";
        } else {
          return "LegacyVB[" + delegate + "]";
        }
    }
}
