/*   -*- Mode: java4; -*-
 * Licensed under the Common Development and Distribution License,
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *   http://www.sun.com/cddl/
 *   
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or 
 * implied. See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * "Portions Copyrighted [2007] [MASAHITO HENMI]"
 *
 */

package com.sun.facelets.el;

import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import java.lang.reflect.Method;
import javax.el.FunctionMapper;
import java.util.logging.*;
/**
 * Composite FunctionMapper that attempts to load the Method from the first
 * FunctionMapper, then the second if <code>null</code>.
 * 
 * @see javax.el.FunctionMapper
 * @see java.lang.reflect.Method
 * 
 * @author Jacob Hookom
 * @version $Id: CompositeFunctionMapper.java,v 1.2 2005/08/24 04:38:56 jhook Exp $
 */
public final class CompositeFunctionMapper extends FunctionMapper {

    // jdk1.4 logging
    protected final static Logger log = Logger.getLogger("strawberry.el.function");
  
    private final FunctionMapper fn0;
    private final FunctionMapper fn1;

    /*
        at com.sun.facelets.el.CompositeFunctionMapper.<>(CompositeFunctionMapper.java:44)
        at com.sun.facelets.compiler.NamespaceHandler.apply(NamespaceHandler.java:47)
        at com.sun.facelets.tag.CompositeFaceletHandler.apply(CompositeFaceletHandler.java:47)
        at com.sun.facelets.compiler.EncodingHandler.apply(EncodingHandler.java:25)
        at com.sun.facelets.impl.DefaultFacelet.apply(DefaultFacelet.java:95)
        at com.sun.facelets.FaceletViewHandler.buildView(FaceletViewHandler.java:506)
      */
    public CompositeFunctionMapper(FunctionMapper fn0, FunctionMapper fn1) {

       // log.trace("RXgN^:" + fn0 + ", " + fn1);

        this.fn0 = fn0;
        this.fn1 = fn1;
    //    throw new RuntimeException();
      
    }

    /**
     * @see javax.el.FunctionMapper#resolveFunction(java.lang.String, java.lang.String)
     */
    public Method resolveFunction(String prefix, String name) {

        if (log.isLoggable(Level.FINE)) {
            log.fine("resolveFunction:" + prefix + ":" + name);
            log.fine("fn0 = " + fn0);
        }
        Method m = this.fn0.resolveFunction(prefix, name);
        if (m == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("fn1 = " + fn1);
            }

            if (fn1 == null) {
                throw new FacesException(prefix + ":" + name + " not found");
            }
            m = this.fn1.resolveFunction(prefix, name);
        }

        // m  reflect.Method ȂŁAlogŌĂAʔȂ
        if (log.isLoggable(Level.FINEST))
            log.finest("   ==> " + ((m != null) ? m.getClass().getName() : "null"));

        //     java.lang.reflect.Method;
        return m;
    }
}
