/*
 * Copyright (C)  2007 Masahito Henmi, All rights reserved.
 */
package strawberry.xmlconfig;

import java.io.IOException;
import java.util.logging.*;
import javax.servlet.*;
import javax.servlet.http.*;
import com.sun.faces.config.beans.*;

import strawberry.mockup.MockServletContext;
/**
 *
 */
public class OriginalConfigServlet extends HttpServlet {
  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.OriginalConfigServlet");
  /**
   *  
   */
  public void init(ServletConfig config) throws ServletException {
    super.init(config);

    log.info("init------------------------");

    ServletContext appli = getServletContext();

    try {
      FacesConfigBean fcb = new FacesConfigBean();

      ConfigureListenerOrig cl = new ConfigureListenerOrig();
      ConfigServletContext sc = new ConfigServletContext(appli);

      sc.addInitParameter("com.sun.faces.validateXml", "true");
      sc.addInitParameter("javax.faces.CONFIG_FILES", "faces-config.xml");

      cl.step1to5(sc, fcb);

   //   new XMLTreeSaver().writeToFile(fcb);

      FactoryBean factory = fcb.getFactory();
      log.info("factory = " + factory);
      if (factory != null) {
        log.info("factory = " + factory.getApplicationFactories());
        log.info("factory = " + factory.getFacesContextFactories());
        log.info("factory = " + factory.getLifecycleFactories());
        log.info("factory = " + factory.getRenderKitFactories());
      }

      ComponentBean[] bean1 = fcb.getComponents();
      for (int i = 0; i < bean1.length; i++) {
        log.info("getComponents " + i + " = " + bean1[i].getComponentClass());
      }

      log.info("getManagedBeans = " + fcb.getManagedBeans());
      
      log.info("getConvertersById = " + fcb.getConvertersById());

      RenderKitBean[] bean2 = fcb.getRenderKits();
      for (int j = 0; j < bean2.length; j++) {
        RenderKitBean rkBean = bean2[j];
        log.info("getRenderKits " + j + " = " + rkBean.getRenderKitId());

        RendererBean[] render = rkBean.getRenderers();
        for (int k = 0; k < render.length; k++) {
          log.info("    render " + k + " = " + render[k].getRendererClass());
        }

      }

      
    } catch (Exception ex) {
      ex.printStackTrace();
    }

  }



  protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

    String pathInfo = request.getPathInfo();
    if (pathInfo != null) {
      pathInfo = pathInfo.toUpperCase();
      if (pathInfo.startsWith("/WEB-INF/")
          || pathInfo.equals("/WEB-INF")
          || pathInfo.startsWith("/META-INF/")
          || pathInfo.equals("/META-INF")) {
        response.sendError(HttpServletResponse.SC_NOT_FOUND);
        return ;
      }
    }

    log.info("service------------------");

  }


}
