/*   -*- Mode: java4; -*-
 * Copyright (C)  2007 Masahito Henmi, All rights reserved.
 */
package strawberry.wrapper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.logging.*;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
/**
 *   Tomcat3  HttpServletRequestbvāA
 *   {ꕶ΍sNX
 *    2007.6.10
 */
public class Tomcat3HttpServletRequest implements HttpServletRequest {
    
    // jdk1.4 logging
    protected final static Logger log = Logger.getLogger("strawberry.ctx.request");
    protected final static Logger headLog = Logger.getLogger("strawberry.ctx.header");
    
    HttpServletRequest delegate;
    /**
     * Create a new Tomcat3HttpServletRequest.
     */
    public Tomcat3HttpServletRequest(HttpServletRequest request) {
        delegate = request;
    }
    
    //---------------------------------------------------------------------
    // ServletRequest interface
    //---------------------------------------------------------------------
    
    public Object getAttribute(String name) {
        log.finer("getAttribute ####");
        return delegate.getAttribute(name);
    }
    
    public Enumeration getAttributeNames() {
        log.finer("getAttributeNames ####");
        return delegate.getAttributeNames();
    }
    
    public String getCharacterEncoding() {
        log.finer("getCharacterEncoding ####");
        return delegate.getCharacterEncoding();
    }
    
    public void setCharacterEncoding(String characterEncoding) throws UnsupportedEncodingException{
        log.finer("setCharacterEncoding ####");
        delegate.setCharacterEncoding( characterEncoding);
    }
    
    public int getContentLength() {
        log.finer("getContentLength ####");
        return delegate.getContentLength();
    }
    
    public String getContentType() {
        log.finer("getContentType ####");
        return delegate.getContentType();
    }
    
    public ServletInputStream getInputStream() throws IOException{
        log.finer("getInputStream ####");
        return delegate.getInputStream();
    }

  /** {ꕶ΍ */
    public String getParameter(String name) {
        log.finer("getParameter ####");
        String wk = delegate.getParameter(name);
        
        String userIn = null;
        try {
            userIn = new String(wk.getBytes("8859_1"), "MS932");
            userIn = removeControlCode(userIn);
        } catch (Exception ex) {
        }
        return userIn;
    }
    private static String removeControlCode(String in) {
        
        if (in == null) return in;
        int n = in.length();
        
        boolean found = false;
        for (int j = 0; j < n; j++) {
            char c = in.charAt(j);
            if (c == 0x7f) {
                found = true;
                break;
            } else if ('\0' <= c && c < ' ') {
                found = true;
                break;
            }
        }

        if (found == false) return in;
        
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < n; i++) {
            char c = in.charAt(i);
            if (c == 0x7f) {
            } else if ('\0' <= c && c < ' ') {
            } else {
                sb.append(c);
            }
        }
        return sb.toString();
    }
    
    public Enumeration getParameterNames() {
        log.finer("getParameterNames ####");
        return delegate.getParameterNames();
    }
    
    public String[] getParameterValues(String name) {
        log.finer("getParameterValues ####");
        return delegate.getParameterValues(name);
    }
    
    public Map getParameterMap() {
        log.finer("getParameterMap ####");
        return delegate.getParameterMap();
    }
    
    public String getProtocol() {
        log.finer("getProtocol ####");
        return delegate.getProtocol();
    }
    
    public String getScheme() {
        log.finer("getScheme ####");
        return delegate.getScheme();
    }
    
    public String getServerName() {
        log.finer("getServerName ####");
        return delegate.getServerName();
    }
    
    public int getServerPort() {
        log.finer("getServerPort ####");
        return delegate.getServerPort();
    }
    
    public BufferedReader getReader() throws UnsupportedEncodingException,IOException {
        return delegate.getReader();
    }
    
    public String getRemoteAddr() {
        log.finer("getRemoteAddr ####");
        return delegate.getRemoteAddr();
    }
    
    public String getRemoteHost() {
        log.finer("getRemoteHost ####");
        return delegate.getRemoteHost();
    }
    
    public void setAttribute(String name, Object value) {
        log.finer("setAttribute ####");
        delegate.setAttribute(name, value);
    }
    
    public void removeAttribute(String name) {
        log.finer("removeAttribute ####");
        delegate.removeAttribute(name);
    }
    
    public Locale getLocale() {
        log.finer("getLocale ####");
        return delegate.getLocale();
    }
    
    public Enumeration getLocales() {
        log.finer("getLocales ####");
        return delegate.getLocales();
    }
    
    public boolean isSecure() {
        return delegate.isSecure();
    }
    
    public RequestDispatcher getRequestDispatcher(String path) {
        log.finer("getRequestDispatcher ####");
        return delegate.getRequestDispatcher(path);
    }
    
    public String getRealPath(String path) {
        log.finer("getRealPath ####");
        return delegate.getRealPath(path);
    }
    
    public int getRemotePort() {
        log.finer("getRemotePort ####");
        return delegate.getRemotePort();
    }
    
    public String getLocalName() {
        log.finer("getLocalName ####");
        return delegate.getLocalName();
    }
    
    public String getLocalAddr() {
        log.finer("getLocalAddr ####");
        return delegate.getLocalAddr();
    }
    
    public int getLocalPort() {
        return delegate.getLocalPort();
    }
    
    //---------------------------------------------------------------------
    
    public String getAuthType() {
        log.finer("getAuthType ####");
        return delegate.getAuthType();
    }
    
    public Cookie[] getCookies() {
        log.finer("getCookies ####");
        return delegate.getCookies();
    }
    
    public long getDateHeader(String name) {
        log.finer("getDateHeader ####");
        return delegate.getDateHeader(name);
    }
    
    public String getHeader(String name) {
        log.finer("getHeader ####");
        return delegate.getHeader(name);
    }
    
    public Enumeration getHeaders(String name) {
        return delegate.getHeaders(name);
    }
    
    public Enumeration getHeaderNames() {
        return delegate.getHeaderNames();
    }
    
    public int getIntHeader(String name) {
        return delegate.getIntHeader(name);
    }
    
    public String getMethod() {
        log.finer("getMethod return s ==> " );
        return delegate.getMethod();
    }
    
    public String getPathInfo() {
        log.finer("getPathInfo return s ==> " );
        return delegate.getPathInfo();
    }
    
    public String getPathTranslated() {
        return delegate.getPathTranslated();
    }
    
    public String getContextPath() {
        log.finer("getContextPath return s ==> " );
        return delegate.getContextPath();
    }
    
    public String getQueryString() {
        log.finer("getQueryString return s ==> " );
        return delegate.getQueryString();
    }
    
    public String getRemoteUser() {
        log.finer("getRemoteUser return s ==> " );
        return delegate.getRemoteUser();
    }
    
    public boolean isUserInRole(String role) {
        return delegate.isUserInRole(role);
    }
    
    public Principal getUserPrincipal() {
        return delegate.getUserPrincipal();
    }
    
    public String getRequestedSessionId() {
        return delegate.getRequestedSessionId();
    }
    
    public String getRequestURI() {
        log.finer("getRequestURI returns => ");
        return delegate.getRequestURI();
    }
    
    public StringBuffer getRequestURL() {
        return delegate.getRequestURL();
    }
    
    public String getServletPath() {
        log.finer("getServletPath   ");
        return delegate.getServletPath();
    }
    
    public HttpSession getSession(boolean create) {
        log.finer("getSession create = " + create);
        return delegate.getSession(create);
    }
    
    public HttpSession getSession() {
        log.finer("getSession  ");
        return delegate.getSession();
    }
    
    public boolean isRequestedSessionIdValid() {
        return delegate.isRequestedSessionIdValid();
    }
    
    public boolean isRequestedSessionIdFromCookie() {
        return delegate.isRequestedSessionIdFromCookie();
    }
    
    public boolean isRequestedSessionIdFromURL() {
        return delegate.isRequestedSessionIdFromCookie();
    }
    
    public boolean isRequestedSessionIdFromUrl() {
        return delegate.isRequestedSessionIdFromUrl();
    }
}
