/*
 * Copyright (C)  2007 Masahito Henmi, All rights reserved.
 */
package strawberry.webapp;

import strawberry.ResourceConfig;
import java.net.URL;
import java.util.logging.*;
import javax.faces.context.FacesContext;
import javax.faces.context.ExternalContext;
/**
 * 
 */
public class FacesResourceConfig extends ResourceConfig {

  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.FacesResourceConfig");

  public URL resolveUrl(String path) {

    URL url = null;
    try {
      path = "/WEB-INF" + path;
/*
      if (! path.endsWith(".html") && !"/".equals(path)) path += ".html";
      int n = path.lastIndexOf("/");
      path = path.substring(n);
      */
      log.info("path = " + path);

      FacesContext faces = FacesContext.getCurrentInstance();
      ExternalContext externalContext = faces.getExternalContext();
      url = externalContext.getResource(path);


    } catch (Exception ex) {
      throw new RuntimeException(ex);
    }
    return url;
  }
}
