/*
 * Copyright (C)  2007 Masahito Henmi, All rights reserved.
 */
package strawberry.viewrenderer;

import com.sun.facelets.DebugWriter;
import com.sun.facelets.tag.jsf.ComponentSupport;
import strawberry.application.StateManagerImpl;
import javax.faces.application.StateManager;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import java.util.logging.*;
import strawberry.viewsupport.ViewBuildable;


public class FaceletViewRender01 extends FaceletViewRender {

    // jdk1.4 logging
    protected final static Logger log = Logger.getLogger("strawberry.savestate");

    protected final static Logger stateSaveLog    = Logger.getLogger("strawberry.state.save");

    DebugWriter debugWriter = new DebugWriter();
  
    public static final String STATE_SAVE_STRING = "<!--dwarf.renderkit.StateRenderer-->";
    
    
    
    public String renderAndStateSave(FacesContext   context,
                                     UIViewRoot     viewToRender,
                                     ViewBuildable  faceletViewHandlerSupport ) {

        String html = null;
        
        // ̃pbP[WɂNXŁAgetCurrentInstance()̋@\
        //StateWriter stateWriter = null;
        try {
            if (/*!this.buildBeforeRestore  ||          Ԃĕ\錻 */
                viewToRender.getChildren().isEmpty()) {
                log.fine("546) UIViewRoot̎qȂ̂xhtmlView");
                faceletViewHandlerSupport.buildView(context, viewToRender);
                // @ExceptionN
            }

            //------------------------------
            StringResponseWriter writer = new StringResponseWriter();
            context.setResponseWriter(writer);

            // TODO: state savingȂ͕\Ȃ悤
            //if (stateSaveLog.isLoggable(Level.FINE)) debugPrintTree(" ", viewToRender);
            debugWriter.printTreeToEncode(viewToRender); // ======== ؂̕\ ========
            
            log.fine("(558) ComponentSupport#encodeRecursive Ăт܂");
            writer.startDocument();
            ComponentSupport.encodeRecursive(context, viewToRender);
            writer.endDocument();
            // finish writing
            writer.close();
            html = writer.toString();


            String stateStr = "";
            if (html.indexOf(STATE_SAVE_STRING) >= 0) {

                // remove transients B sƁAقƂǂ폜 
                ComponentSupport.removeTransient(viewToRender);

                debugWriter.printTreeToSave(viewToRender); // ======== ؂̕\ ========
                
                StateManagerImpl stateMgr = (StateManagerImpl) context.getApplication().getStateManager();
                log.fine("70) saveSerializedView" + stateMgr.getClass().getName());
              
                Object stateObj = stateMgr.saveSerializedView(context);

                StringResponseWriter clientState = new StringResponseWriter();

                stateMgr.writeState(context,
                                    (StateManager.SerializedView) stateObj, clientState);
                stateStr = clientState.toString();

            } else {
              log.fine("81) saveSerializedView XLbv ----------------- ");

            }


          
            if (stateSaveLog.isLoggable(Level.FINE))
                stateSaveLog.fine("591) *******************************  stateStr.length() = " + stateStr.length());

            html = html.replaceFirst(STATE_SAVE_STRING, stateStr);

            //if (stateSaveLog.isLoggable(Level.FINE))
            //    stateSaveLog.fine("596) html.length() = " + html.length());

          //  HttpServletResponse res = (HttpServletResponse) context.getExternalContext().getResponse();
          //  outHtml( res,  html);
        } catch (Throwable thr) {
            log.log(Level.SEVERE, "602  ------- catch Throwable", thr);
            if (thr instanceof RuntimeException)
              throw (RuntimeException) thr;
            else
              throw new RuntimeException(thr);
        }
        return html;
    }


}
