/*
 * Copyright (C)  2007 Masahito Henmi, All rights reserved.
 */
package strawberry.viewhandler;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.render.RenderKitFactory;
/**
 * Created on 2007/06/09,
 *
 * @author HENMI
 */
public class MobileViewHandler extends ViewHandler {

    // jdk1.4 logging
    protected final static Logger log = Logger.getLogger("strawberry.vh.MobileViewHandler");
  
  ViewHandler original = null;
  /** RXgN^ */
  public MobileViewHandler(ViewHandler vh) {
    original = vh;
  }

  public void renderView(FacesContext facesContext, UIViewRoot uIViewRoot) throws IOException, FacesException {
    original.renderView(facesContext, uIViewRoot);
  }

  public void writeState(FacesContext facesContext) throws IOException {
    original.writeState(facesContext);
  }

  public String calculateRenderKitId(FacesContext facesContext) {
    //return original.calculateRenderKitId(facesContext);
        Map map = facesContext.getExternalContext().getRequestHeaderMap();
        String x = (String) map.get("User-Agent"); //"HTTP_USER_AGENT"

        log.fine("61) User-Agent = '" + x + "'");
        if (x == null) {
            return RenderKitFactory.HTML_BASIC_RENDER_KIT;
        } else if (x.indexOf("DoCoMo") >= 0) {
            log.fine("69)  calculateRenderKitId => DoCoMo");
            return "DoCoMo";
        } else if (x.indexOf("J-PHONE") >= 0) {
            log.fine("69)  calculateRenderKitId => J-PHONE");
            return "J-PHONE";
        } else if (x.indexOf("UP.Browser") >= 0) {
            log.fine("69)  calculateRenderKitId => au");
            return "au";
        } else {
            return RenderKitFactory.HTML_BASIC_RENDER_KIT;
        }

  }

  public Locale calculateLocale(FacesContext facesContext) {
     return original.calculateLocale(facesContext);


  }

  public UIViewRoot restoreView(FacesContext facesContext, String string) {
    
    return original.restoreView(facesContext, string);
  }

  public String getResourceURL(FacesContext facesContext, String string) {
    return original.getResourceURL(facesContext, string);
  }

  public String getActionURL(FacesContext facesContext, String string) {
    return original.getActionURL(facesContext, string);
  }

  public UIViewRoot createView(FacesContext facesContext, String string) {
    
    return original.createView(facesContext, string);
  }
  
}
