/*   -*- Mode: java4; -*-
 * "Portions Copyrighted [2007] [MASAHITO HENMI]"
 *
 *   savestate     550
 *   restoreVirw   330
 *        
 */
package strawberry.viewhandler;

import com.sun.facelets.FaceletFactory;
import com.sun.facelets.tag.ui.UIDebug;
import java.io.*;
import java.util.*;
import java.util.logging.*;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpServletResponse;

//import strawberry.application.ViewHandlerImpl;
import strawberry.savemethod.AbstractSaveMethod;
import strawberry.savemethod.DefaultSaveMethod;
import strawberry.viewrenderer.FaceletViewRender01;
import strawberry.viewsupport.FaceletViewHandlerSupport;
import strawberry.viewsupport.FaceletViewHandlerSupportImpl;
/**
 * ViewHandler implementation for Facelets
 * 
 * @author Jacob Hookom
 * @version $Id: FaceletViewHandler.java,v 1.49.2.6 2006/03/20 07:22:00 jhook
 *          Exp $
 */
public class FaceletViewHandlerBase extends ViewHandler implements FaceletFactoryAware {

    // jdk1.4 logging
    protected final static Logger log = Logger.getLogger("strawberry.vh");

    protected final static Logger stateRestoreLog = Logger.getLogger("strawberry.state.restore");
    protected final static Logger stateSaveLog    = Logger.getLogger("strawberry.state.save");

    protected final ViewHandler parent;

    private FaceletFactory faceletFactory;

    /**
     *  RXgN^
     */
    public FaceletViewHandlerBase() {
        this.parent = new ViewHandlerImpl();
        add(new DefaultSaveMethod());
    }
    
    /**
     *  RXgN^
     */
    public FaceletViewHandlerBase(ViewHandler parent) {
        this.parent = parent;
        add(new DefaultSaveMethod());
    }

    ArrayList list = new ArrayList();

    public void add(AbstractSaveMethod obj) {
        list.add(obj);
    }

    /** ǉ */
    public FaceletFactory getFaceletFactory() { return faceletFactory; }

    public void setFaceletFactory(FaceletFactory ff) {
        faceletFactory = ff;
    }


    FaceletViewHandlerSupport _fvhSupport = null;

    public FaceletViewHandlerSupport getFaceletViewHandlerSupport() {
        if (_fvhSupport == null) {
            _fvhSupport = new FaceletViewHandlerSupportImpl(faceletFactory);
        }
        return _fvhSupport;
    }

    public void setFaceletViewHandlerSupport(FaceletViewHandlerSupport x) {
        _fvhSupport = x;
    }


    /** ViewHandler ̎ */
    public UIViewRoot restoreView( FacesContext context, String viewId) {

        boolean found = false;
        UIViewRoot root = null;
        for (int i = 0; i < list.size(); i++) {
            AbstractSaveMethod wk = (AbstractSaveMethod) list.get(i);
            if (wk.isSaveStatedView(context)) {
                root = wk.restoreView(viewId, context);
                found = true;
                break;
            }
        }
        if (!found) {
            // xhtmlǂݍ
            log.fine("92) com.sun.faces.VIEW  ̂ xhtmlVIEW쐬܂");

            UIViewRoot viewRoot = createView(context, viewId);
            context.setViewRoot(viewRoot);
            try {
                getFaceletViewHandlerSupport().buildView(context, viewRoot);
                root = viewRoot;
            } catch (IOException ioe) {
                log.log(Level.SEVERE, "343) Error Building View", ioe);
            }
        }
        return root;
    }

/*
*/
    protected ResponseWriter createResponseWriter(FacesContext context) throws IOException, FacesException {

        log.info("createResponseWriter Ă΂܂");
        throw new UnsupportedOperationException();
    }


    /** ViewHandler ̎ */
    public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {

        log.fine("---------------------");
        String html = "";

        if (! viewToRender.isRendered()) {
            log.fine("168) ! isRendered()");
            return;
        } else {


            if (viewToRender.getChildren().isEmpty()) {
                log.fine("168) UIViewRoot̎qȂ̂xhtmlView");
                getFaceletViewHandlerSupport().buildView(context, viewToRender);
                // @ExceptionN
            }


            //String html = modifiedRenderView(context, viewToRender);
            html = renderAndSave(context, viewToRender);
        }
        
        // exit if the view is not to be rendered
        HttpServletResponse res = (HttpServletResponse) context.getExternalContext().getResponse();
        log.fine("res = " + res);
        outHtml( res,  html);
    }

    public String renderAndSave(FacesContext context, UIViewRoot viewToRender) {

        // f:view stateManager=̐ݒo
        // @see  com.sun.facelets.tag.jsf.core.ViewHandler
        Object obj = context.getExternalContext().getRequestMap().get("facelets.stateManager");
        String method = (String) obj;
        log.fine("method = " + method);
        if (method == null) {
            method = "default";
        }
        
        boolean found = false;
        String html = null;
        for (int i = 0; i < list.size(); i++) {
            AbstractSaveMethod wk = (AbstractSaveMethod) list.get(i);

            String name = wk.getSaveMethodName();
            
            log.fine("166) i = " + i + ", " + name + ", " + method);
            
            if (method.equals(name)) {
                html = wk.renderAndSave( context,  viewToRender );
                found = true;
                break;
            }
        }
        if (! found) {
            AbstractSaveMethod wk = (AbstractSaveMethod) list.get(0);
            html = wk.renderAndSave( context,  viewToRender );
        }
        return html;
    }

    // C
    public String modifiedRenderView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {

        log.info("394) ----------");

        // exit if the view is not to be rendered
        if (!viewToRender.isRendered()) {
            return "";
        }

        // f:view stateManager=̐ݒo
        // @see  com.sun.facelets.tag.jsf.core.ViewHandler
        Object manager = context.getExternalContext().getRequestMap().get("facelets.stateManager");

        log.fine("498) manager = " + manager);

        String html = new FaceletViewRender01().renderAndStateSave( context,
                                                                    viewToRender,
                                                                    getFaceletViewHandlerSupport());
        return html;
    }


    public void outHtml(HttpServletResponse res, String html) throws IOException {
        res.setContentType(advisableContentType);
        PrintWriter out = res.getWriter();
     // out.println(html);
        out.print(html);
    }

    /**
     *  ߂ContentTypeԂ
     */
    public static final String advisableContentType = "text/html; charset=\"" + "Windows-31J" + "\"";


    /** ViewHandler ̎ */
    /*
http:// ` /apollon/par/FPage12Time
java.lang.UnsupportedOperationException
        at strawberry.viewhandler.FaceletViewHandler.writeState(FaceletViewHandler.java:470)
        at com.sun.faces.renderkit.html_basic.FormRenderer.encodeEnd(FormRenderer.java:215)
     */
    public void writeState(FacesContext context) throws IOException {

        log.info("223) writeStateĂ΂܂B");
        throw new UnsupportedOperationException();
    }

    /** ViewHandler ̎ */
    public Locale calculateLocale(FacesContext context) {

        log.fine("230) calculateLocaleĂ΂܂B");
        return this.parent.calculateLocale(context);
    }

    /** ViewHandler ̎ */
    public String calculateRenderKitId(FacesContext context) {

        log.fine("237) calculateRenderKitIdĂ΂܂B");
        return this.parent.calculateRenderKitId(context);
    }

    /** ViewHandler ̎ */
    public UIViewRoot createView(FacesContext context, String viewId) {

        if (UIDebug.debugRequest(context)) {
            log.fine("245) createView ");
            return new UIViewRoot();
        }
        log.fine("248) parent  createView() Ă");
        UIViewRoot wk = this.parent.createView(context, viewId);

        return wk;
    }

    /** ViewHandler ̎ */
    public String getActionURL(FacesContext context, String viewId) {

        String wk =  viewId;
        log.fine("(271) getActionURL '" + viewId + "'  -->  '" + wk + "'");
        return wk;
    }

    /** ViewHandler ̎ */
    public String getResourceURL(FacesContext context, String path) {
        return this.parent.getResourceURL(context, path);
    }
}
