/*   -*- Mode: java4; -*-
 *
 * Copyright (C)  2007 Masahito Henmi, All rights reserved.
 */
package strawberry.viewhandler;

import javax.faces.context.FacesContext;
import javax.faces.application.ViewHandler;
import javax.faces.render.RenderKitFactory;
import java.util.Map;
import java.util.logging.*;
import strawberry.ViewIdUtil;
/**
 * ViewHandler implementation for Facelets
 */
public class FaceletViewHandler extends FaceletViewHandlerBase {

    // jdk1.4 logging
    protected final static Logger log = Logger.getLogger("strawberry.vh.FaceletViewHandler");


    /**
     *  RXgN^
     */
    public FaceletViewHandler() {
    }
    
    /**
     *  RXgN^
     */
    public FaceletViewHandler(ViewHandler parent) {
        super( parent);
    }

    /** ViewHandler ̎ */
    public String getActionURL(FacesContext context, String viewId) {

        if (ViewIdUtil.isCustomizedViewId(context.getExternalContext())) {
            // JX^}CY
            String wk = ".." + viewId;
            log.fine("(35) getActionURL '" + viewId + "'  -->  '" + wk + "'");
            return wk;
        } else {
            // ʏ
           return this.parent.getActionURL(context, viewId);
        }
    }
    public String getResourceURL(FacesContext context, String path) {

        if (path == null) {
            log.info("42) path == null");
            return path;
        }

        if (path.startsWith("/")) {
            String wk =  context.getExternalContext().getRequestContextPath() + path;
            log.config("49) wk '" +  wk + "'");
            return wk;
        } else {
            log.config("52) path '" + path + "'");
            return (path);
        }
    }

    /** gтgƂȂ */
    public String calculateRenderKitId(FacesContext context) {
        
        Map map = context.getExternalContext().getRequestHeaderMap();
        String x = (String) map.get("User-Agent"); //"HTTP_USER_AGENT"

        log.fine("61) User-Agent = '" + x + "'");
        if (x == null) {
            return RenderKitFactory.HTML_BASIC_RENDER_KIT;
        } else if (x.indexOf("DoCoMo") >= 0) {
            log.fine("69)  calculateRenderKitId => DoCoMo");
            return "DoCoMo";
        } else if (x.indexOf("J-PHONE") >= 0) {
            log.fine("69)  calculateRenderKitId => J-PHONE");
            return "J-PHONE";
        } else if (x.indexOf("UP.Browser") >= 0) {
            log.fine("69)  calculateRenderKitId => au");
            return "au";
        } else {
            return RenderKitFactory.HTML_BASIC_RENDER_KIT;
        }
    }

}
