/*
 * Copyright (C)  2007 Masahito Henmi, All rights reserved.
 */
package strawberry.util;

import java.util.*;

/**
 * HTMLɊւ郆[eBeBNX
 */
public class BtvHtmlUtility {
  protected static Hashtable replace;

  static {
    replace = new Hashtable(5);
    replace.put(new Character('<'), "&lt;");
    replace.put(new Character('>'), "&gt;");
    replace.put(new Character('&'), "&amp;");
    replace.put(new Character('"'), "&quot;");
    replace.put(new Character('\r'), "<BR>");

  }
  /**
   * ̃NX̓CX^XȂ
   */
  private BtvHtmlUtility() {
  }
  /**
   * 񒆂̓ꕶ HTML ̓ꕶ\ɕϊ
   *    '<' -> "&lt;"
   *    '>' -> "&gt;"
   *    '&' -> "&amp;"
   *    '"' -> "&quot;"
   *    '\r' -> "<BR>"
   *
   * @return java.lang.String
   * @param element java.lang.String
   */
  public static String EncodeReplaceEntities(String element) {
    if (element == null || element.length() == 0) {
      return "";
    }
    int length = element.length();
    StringBuffer buf = new StringBuffer(length);
    for (int i = 0; i < length; i++) {
      char c = element.charAt(i);
      String entityName = (String) replace.get(new Character(c));
      if (entityName == null) {
        buf.append(c);
      } else {
        buf.append(entityName);
      }
    }
    return buf.toString();
  }
}
