package strawberry.renderkit.html_basic;

import com.sun.faces.renderkit.RenderKitImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
/**
 * @author masa
 */
public class DebugRenderer extends HtmlBasicRenderer {

  /** Creates a new instance of DebugRenderer */
  public DebugRenderer() {
  }

  public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
    ResponseWriter writer = context.getResponseWriter();

    Application app = context.getApplication();

    writer.startElement("h1", null);
    writer.writeText("getComponentTypes", "getComponentTypes");
    writer.endElement("h1");
    Iterator it = app.getComponentTypes();
    printIt(writer, it);

    writer.startElement("h1", null);
    writer.writeText("getConverterIds", "getConverterIds");
    writer.endElement("h1");
    Iterator it2 = app.getConverterIds();
    printIt(writer, it2);

    writer.startElement("h1", null);
    writer.writeText("getValidatorIds", "getValidatorIds");
    writer.endElement("h1");
    Iterator it3 = app.getValidatorIds();
    printIt(writer, it3);

  }

  public void printIt(ResponseWriter writer, Iterator it) throws IOException {

    ArrayList list = new ArrayList();
    while (it.hasNext()) {
      Object obj = it.next();
      list.add(obj);
    }

    Collections.sort(list);

    for (int i = 0; i < list.size(); i++) {
      Object wk = list.get(i);
      String str = wk.toString();
      
      writer.startElement("p", null);
      writer.writeText(str, str);
      writer.endElement("p");
    }
  }
}
