/*    -*- Mode: java4; -*-
 * $Id: LifecycleFactoryImpl.java,v 1.21.32.1 2006/04/12 19:32:19 ofung Exp $
 */

/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at
 * https://javaserverfaces.dev.java.net/CDDL.html or
 * legal/CDDLv1.0.txt. 
 * See the License for the specific language governing
 * permission and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at legal/CDDLv1.0.txt.    
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * 
 * 
 * "Portions Copyrighted [2007] [MASAHITO HENMI]"
 * 
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package strawberry.lifecycle;

import com.sun.faces.lifecycle.Phase;
import com.sun.faces.util.Util;

import javax.faces.FacesException;
import javax.faces.event.PhaseId;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;

import java.util.HashMap;
import java.util.Iterator;
import strawberry.lifecycle.LifecycleImpl;
import java.util.logging.*;
/**
 * <B>LifecycleFactoryImpl</B> is the stock implementation of Lifecycle
 * in the JSF RI. <P>
 *
 * @version $Id: LifecycleFactoryImpl.java,v 1.21.32.1 2006/04/12 19:32:19 ofung Exp $
 * @see	javax.faces.lifecycle.LifecycleFactory
 */

public class LifecycleFactoryImpl extends LifecycleFactory {

//
// Protected Constants
//
    static final int FIRST_PHASE = PhaseId.RESTORE_VIEW.getOrdinal();
    static final int LAST_PHASE = PhaseId.RENDER_RESPONSE.getOrdinal();

    // jdk1.4 logging
    protected final static Logger log = Logger.getLogger("strawberry.lifecycle");

//
// Class Variables
//

//
// Instance Variables
//

// Attribute Instance Variables

// Relationship Instance Variables

    protected HashMap lifecycleMap = null;
    protected Object lock = null;

//
// Constructors and Initializers    
//

    public LifecycleFactoryImpl() {
        super();
        lifecycleMap = new HashMap();

        // P
        LifecycleImpl wkImpl = new LifecycleImpl();
        wkImpl.addPhaseListener(new strawberry.event.PhaseListenerImpl());
        
        lifecycleMap.put(LifecycleFactory.DEFAULT_LIFECYCLE,
                         new LifecycleWrapper(wkImpl, false));

        // Q
        LifecycleImpl2 life2 = new LifecycleImpl2();
        life2.addPhaseListener(new strawberry.event.PhaseListenerImpl());
        
        lifecycleMap.put("Strawberry",
                         new LifecycleWrapper(life2, false));


        if (log.isLoggable(Level.FINER)) {
            log.finer("Created Default Lifecycle");
        }
        lock = new Object();
    }

//
// Class methods
//

//
// General Methods
//

    /**
     * @return true iff lifecycleId was already created
     */

    boolean alreadyCreated(String lifecycleId) {
        LifecycleWrapper wrapper = (LifecycleWrapper) lifecycleMap.get(
            lifecycleId);
        return (null != wrapper && wrapper.created);
    }


    /**
     * POSTCONDITION: If no exceptions are thrown, it is safe to proceed with
     * register*().;
     */

    Lifecycle verifyRegisterArgs(String lifecycleId,
                                 int phaseId, Phase phase) {
        String message = null;
        LifecycleWrapper wrapper = null;
        Lifecycle result = null;
        Object[] params = {lifecycleId};
        if (null == lifecycleId || null == phase) {
            throw new NullPointerException(
                Util.getExceptionMessageString(Util.NULL_PARAMETERS_ERROR_MESSAGE_ID));
        }

        if (null ==
            (wrapper = (LifecycleWrapper) lifecycleMap.get(lifecycleId))) {
            message = Util.getExceptionMessageString(
                Util.LIFECYCLE_ID_NOT_FOUND_ERROR_MESSAGE_ID,
                params);
            log.severe("Error: " + message);
            throw new IllegalArgumentException(message);
        }
        result = wrapper.instance;
        Util.doAssert(null != result);

        if (alreadyCreated(lifecycleId)) {
            message = Util.getExceptionMessageString(
                Util.LIFECYCLE_ID_ALREADY_ADDED_ID,
                params);
            log.severe("Error: " + message);
            throw new IllegalStateException(message);
        }

        if (!((FIRST_PHASE <= phaseId) &&
            (phaseId <= LAST_PHASE))) {
            params = new Object[]{Integer.toString(phaseId)};
            message = Util.getExceptionMessageString(
                Util.PHASE_ID_OUT_OF_BOUNDS_ERROR_MESSAGE_ID,
                params);
            log.severe("Error: " + message);
            throw new IllegalArgumentException(message);
        }
        return result;
    }

//
// Methods from LifecycleFactory
//

    public void addLifecycle(String lifecycleId, Lifecycle lifecycle) {
        if (lifecycleId == null || lifecycle == null) {
            throw new NullPointerException(
                Util.getExceptionMessageString(Util.NULL_PARAMETERS_ERROR_MESSAGE_ID));
        }
        if (null != lifecycleMap.get(lifecycleId)) {
            Object params[] = {lifecycleId};
            String message =
                Util.getExceptionMessageString(Util.LIFECYCLE_ID_ALREADY_ADDED_ID,
                                         params);
            log.severe("addLifecycle: " + message);
            throw new IllegalArgumentException(message);
        }
        lifecycleMap.put(lifecycleId, new LifecycleWrapper(lifecycle, false));
        if (log.isLoggable(Level.FINE)) {
            log.fine("addedLifecycle: " + lifecycleId + " " + lifecycle);
        }
    }


    public Lifecycle getLifecycle(String lifecycleId) throws FacesException {
        Lifecycle result = null;
        LifecycleWrapper wrapper = null;

        if (null == lifecycleId) {
            throw new NullPointerException(
                Util.getExceptionMessageString(Util.NULL_PARAMETERS_ERROR_MESSAGE_ID));
        }

        if (null == lifecycleMap.get(lifecycleId)) {
            Object[] params = {lifecycleId};
            String message =
                Util.getExceptionMessageString(
                    Util.CANT_CREATE_LIFECYCLE_ERROR_MESSAGE_ID,
                    params);
            log.severe("LifecycleId " + lifecycleId + " does not exist");
            throw new IllegalArgumentException(message);
        }

        wrapper = (LifecycleWrapper) lifecycleMap.get(lifecycleId);
        result = wrapper.instance;
        wrapper.created = true;

        if (log.isLoggable(Level.FINEST)) {
            log.finest("219) getLifecycle: " + lifecycleId + " " + result);
        }
        return result;
    }


    public Iterator getLifecycleIds() {
        return lifecycleMap.keySet().iterator();
    }

//
// Helper classes
//

    static class LifecycleWrapper extends Object {


        Lifecycle instance = null;
        boolean created = false;


        LifecycleWrapper(Lifecycle newInstance, boolean newCreated) {
            instance = newInstance;
            created = newCreated;
        }

    } // end of class LifecycleWrapper


// The testcase for this class is TestLifecycleFactoryImpl.java 


} // end of class LifecycleFactoryImpl
