/*   -*- Mode: java4; -*-
 * $Id: InvokeApplicationPhase.java,v 1.15.32.1 2006/04/12 19:32:19 ofung Exp $
 */

/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at
 * https://javaserverfaces.dev.java.net/CDDL.html or
 * legal/CDDLv1.0.txt. 
 * See the License for the specific language governing
 * permission and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at legal/CDDLv1.0.txt.    
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * 
 * 
 * "Portions Copyrighted [2007] [MASAHITO HENMI]"
 * 
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */
package strawberry.lifecycle;

import com.sun.faces.lifecycle.*;
import com.sun.faces.util.Util;

import javax.faces.FacesException;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import java.util.logging.*;
/**
 * <B>Lifetime And Scope</B> <P> Same lifetime and scope as
 * DefaultLifecycleImpl.
 *
 * @version $Id: InvokeApplicationPhase.java,v 1.15.32.1 2006/04/12 19:32:19 ofung Exp $
 */

public class InvokeApplicationPhase extends Phase {

    // jdk1.4 logging
    protected final static Logger log = Logger.getLogger("strawberry.lifecycle");

//    protected static Log log = LogFactory.getLog(InvokeApplicationPhase.class);


    public InvokeApplicationPhase() {
        super();
    }


    public PhaseId getId() {
        return PhaseId.INVOKE_APPLICATION;
    }


    public void execute(FacesContext facesContext) throws FacesException {
        
        log.fine("(88) Entering InvokeApplicationsPhase");
        

        UIViewRoot root = facesContext.getViewRoot();
        Util.doAssert(null != root);

        try {
            log.fine("(94) call ... processApplication()");
            root.processApplication(facesContext);
        } catch (RuntimeException re) {

          log.severe("(98) RuntimeException");
          String exceptionMessage = re.getMessage();
            if (null != exceptionMessage) {
                    log.severe("80) " + exceptionMessage);
            }
            throw new FacesException(exceptionMessage, re);
        }

        log.fine("(106) Exiting InvokeApplicationsPhase");
    }

//
// Class methods
//

//
// General Methods
//

//
// Methods from Phase
//


// The testcase for this class is TestInvokeApplicationPhase.java


} // end of class InvokeApplicationPhase
