//  -*- Mode: java4; -*-
package strawberry.init;

import com.sun.faces.config.beans.ComponentBean;
import com.sun.faces.config.beans.FacesConfigBean;
import com.sun.faces.RIConstants;

import javax.servlet.ServletContext;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.render.RenderKitFactory;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import strawberry.el.GlobalELContext;
import strawberry.application.I18n;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.*;
import strawberry.ResourceConfig;
import strawberry.application.NavigationRuleAware;
import strawberry.config.ConfigureListener;
import strawberry.context.FacesContextEL;
import strawberry.context.ResourceConfigWrapper;
import strawberry.xmlconfig.ConfigServletContext;
import strawberry.xmlconfig.ConfigureListenerOrig;
import com.sun.faces.config.beans.*;

import com.sun.faces.util.Util;
import javax.faces.render.Renderer;
import javax.faces.render.RenderKit;
import javax.faces.lifecycle.LifecycleFactory;
import com.sun.faces.application.ConfigNavigationCase;

/**
 * Created on 2007/05/25,
 * @author  masahito henmi
 */
public class FacesContextInitializer1 implements FacesContextInitializer{

    // jdk1.4 logging
    protected final static Logger log = Logger.getLogger("strawberry.init.app");
    // jdk1.4 logging
    protected final static Logger initLog = Logger.getLogger("strawberry.init");
    protected final static Logger elLog = Logger.getLogger("strawberry.el.common");

    RenderKitFactory   rkFactory   = null;
    Application        application = null;

    ApplicationCreator appCreator = new ApplicationCreator();

    ApplicationNav appliNav = new ApplicationNav();

    /** ftHg̃CtTCN
     *  wlkŎw肳΁Aɏւ
     */
    String lifecycleFactoryClassName = "strawberry.lifecycle.LifecycleFactoryImpl";

    public LifecycleFactory createLifecycleFactory() {

        LifecycleFactory lifecycleFactory = null;
        try {
            Object wk = Class.forName(lifecycleFactoryClassName).newInstance();
            lifecycleFactory = (LifecycleFactory) wk;
        } catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return lifecycleFactory;
    }


    /** eXgR[h (FaceletsBridgeUtil) p */
    public Application getApplication() {
        return application;
    }


    /** Xml */
    public void processXmls(ExternalContext ec, ResourceConfig rc) {
        ResourceConfigWrapper rr = new ResourceConfigWrapper(rc);
        ServletContext sc = (ServletContext) ec.getContext();
        ConfigureListener cl = new ConfigureListener();

        initLog.fine("96) digesterg xml܂ ");

        FacesConfigBean fcb = new FacesConfigBean();

        ConfigureListenerOrig orig = new ConfigureListenerOrig();
        ConfigServletContext csc = new ConfigServletContext(sc);

        csc.addInitParameter("com.sun.faces.validateXml", "true");
        csc.addInitParameter("javax.faces.CONFIG_FILES", "faces-config.xml");

        orig.step1to5(csc, fcb); // XMLǂݍ܂Afcbɂ̓eǉ

        if (initLog.isLoggable(Level.FINE)) {
            ComponentBean[] bean1 = fcb.getComponents();
            for (int i = 0; i < bean1.length; i++) {
                initLog.fine("70) getComponents " + i + " = " + bean1[i].getComponentClass());
            }
        }

        //  typeɉāAClassLoadeřo@ς
        cl.setManagedBeanFactoryClass("ManagedBeanFactoryApp");
        try {
            // }l[Whr[
            cl.configure(sc, fcb);
            // ServletContextɍꂽApplicationAssociateۑ
        } catch (Exception ex) {
            initLog.log(Level.WARNING, "Application", ex);
        }

        /** wlk̐ݒ\ */

        if (fcb.getFactory() == null) {
            initLog.config("95)  fcb.getFactory() = null ");
        } else {
            List lifecycles = fcb.getFactory().getLifecycleFactories();

            if (lifecycles == null || lifecycles.size() == 0)
                initLog.config("LifecycleFactories.size() = 0 ");

            for (int i = 0; i < lifecycles.size(); i++) {
                String lifecycle = (String) lifecycles.get(i);
                initLog.config("lifecycle(" + i + ") = " + lifecycle );
                this.lifecycleFactoryClassName = lifecycle;
            }
        }

        if (fcb.getApplication() != null) {
        
          String[] nhs = fcb.getApplication().getNavigationHandlers();

          if (nhs == null || nhs.length == 0) initLog.info("NavigationHandlers.size() = 0 ");

          for (int i = 0; i < nhs.length; i++) {
            initLog.log(Level.CONFIG, "getNavigationHandlers(" + i + ") = '" + nhs[i] +"' ----------------------**" );

            appCreator.setNavigationHandlerClass(nhs[i]);
          }
        }

        initLog.fine("Application");
        application = appCreator.initializeApplication(ec, rr, fcb); //Application쐬E

        try {
            configureFromBean(application, fcb); //wlko^
        } catch (Exception ex2) {
            initLog.log(Level.WARNING, "Application", ex2);
        }
        rkFactory = appCreator.initializeRenderKitFactory(ec, rr);
        initLog.fine("44) RenderKitFactory = " + rkFactory);

        try {
            configure(fcb.getRenderKits(), rkFactory, rc);
        } catch (Exception ex3) {
            initLog.log(Level.WARNING, "Application", ex3);
        }
    }

    public void configureFromBean(Application application, FacesConfigBean facesConfig) throws Exception {

        configure(application, facesConfig.getComponents());
        configure(application, facesConfig.getConvertersByClass());
        configure(application, facesConfig.getConvertersById());

        configure(             facesConfig.getNavigationRules());

        Map caseListMap = appliNav.getNavigationCaseListMappings();
        Set wildCardSet = appliNav.getNavigationWildCardList();

        if (initLog.isLoggable(Level.FINE)) {
            log.fine("176) caseListMap:" + caseListMap);
            log.fine("177) wildCardSet:" + wildCardSet);
        }

        Object navHan = application.getNavigationHandler();

        if (navHan instanceof NavigationRuleAware) {

            NavigationRuleAware ruleAware = (NavigationRuleAware) navHan;
            ruleAware.setRule(caseListMap, wildCardSet);
        }

        configure(application, facesConfig.getValidators());
    }
    /**
     * <p>Configure all registered navigation rules.</p>
     *
     * @param config Array of <code>NavigationRuleBean</code> that contains
     *               our configuration information
     */
    private void configure(NavigationRuleBean config[]) {

        if (config == null) {
            return;
        }

        if (null == appliNav) {
            return;
        }

        for (int i = 0; i < config.length; i++) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("addNavigationRule(" +
                         config[i].getFromViewId() + ')');
            }
            NavigationCaseBean ncb[] = config[i].getNavigationCases();
            for (int j = 0; j < ncb.length; j++) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("addNavigationCase(" +
                             ncb[j].getFromAction() + ',' +
                             ncb[j].getFromOutcome() + ',' +
                             ncb[j].isRedirect() + ',' +
                             ncb[j].getToViewId() + ')');
                }
                ConfigNavigationCase cnc = new ConfigNavigationCase();
                if (config[i].getFromViewId() == null) {
                    cnc.setFromViewId("*");
                } else {
                    cnc.setFromViewId(config[i].getFromViewId());
                }
                cnc.setFromAction(ncb[j].getFromAction());
                String fromAction = ncb[j].getFromAction();
                if (fromAction == null) {
                    fromAction = "-";
                }
                cnc.setFromOutcome(ncb[j].getFromOutcome());
                String fromOutcome = ncb[j].getFromOutcome();
                if (fromOutcome == null) {
                    fromOutcome = "-";
                }
                cnc.setToViewId(ncb[j].getToViewId());
                String toViewId = ncb[j].getToViewId();
                if (toViewId == null) {
                    toViewId = "-";
                }
                cnc.setKey(cnc.getFromViewId() + fromAction + fromOutcome);
                if (ncb[j].isRedirect()) {
                    cnc.setRedirect("true");
                } else {
                    cnc.setRedirect(null);
                }
                appliNav.addNavigationCase(cnc);
            }
        }

    }


    /**
     * <p>Configure all registered validators.</p>
     *
     * @param config Array of <code>ValidatorBean</code> that contains
     *               our configuration information
     */
    private void configure(Application application, ValidatorBean config[]) throws Exception {

        if (config == null) {
            return;
        }

        for (int i = 0; i < config.length; i++) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("addValidator(" +
                         config[i].getValidatorId() + ',' +
                         config[i].getValidatorClass() + ')');
            }
            application.addValidator(config[i].getValidatorId(),
                                     config[i].getValidatorClass());
        }

    }

    /**
     * <p>Configure all registered components.</p>
     *
     * @param config Array of <code>ComponentBean</code> that contains
     *               our configuration information
     */
    public void configure(Application application, ComponentBean config[]) throws Exception {

        if (config == null) {
            return;
        }

        for (int i = 0; i < config.length; i++) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("75) addComponent(" +
                         config[i].getComponentType() + ',' +
                         config[i].getComponentClass() + ')');
            }
            application.addComponent(config[i].getComponentType(),
                                     config[i].getComponentClass());
        }

    }

    /**
     * <p>Configure all registered converters.</p>
     *
     * @param config Array of <code>ConverterBean</code> that contains
     *               our configuration information
     */
    public void configure(Application application, ConverterBean config[]) throws Exception {
        int i = 0, len = 0;

        /* at a minimum, configure the primitive converters
        for (i = 0, len = PRIM_CLASSES_TO_CONVERT.length; i < len; i++) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("addConverterByClass(" +
                          PRIM_CLASSES_TO_CONVERT[i] + ',' +
                          CONVERTERS_FOR_PRIMS[i] + ')');
            }
            application.addConverter(PRIM_CLASSES_TO_CONVERT[i],
                                     CONVERTERS_FOR_PRIMS[i]);
        }*/

        if (config == null) {
            return;
        }

        for (i = 0, len = config.length; i < len; i++) {
            if (config[i].getConverterId() != null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("112) addConverterById(" +
                             config[i].getConverterId() + ',' +
                             config[i].getConverterClass() + ')');
                }
                application.addConverter(config[i].getConverterId(),
                                         config[i].getConverterClass());
            } else {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("120) addConverterByClass(" +
                             config[i].getConverterForClass() + ',' +
                             config[i].getConverterClass() + ')');
                }
                Class clazz = Util.getCurrentLoader(this).loadClass
                    (config[i].getConverterForClass());
                application.addConverter(clazz,
                                         config[i].getConverterClass());
            }
        }

    }

    /**
     * <p>Configure all registered renderKits.</p>
     *
     * @param config Array of <code>RenderKitBean</code> that contains
     *               our configuration information
     */
    public void configure(RenderKitBean config[], RenderKitFactory rkFactory, Object fallback) throws Exception {

        if (config == null) {
            return;
        }

        for (int i = 0; i < config.length; i++) {

            if (log.isLoggable(Level.FINE)) {
                log.fine("90) i = " + i);
            }

            RenderKit rk = rkFactory.getRenderKit(null, config[i].getRenderKitId());
            if (rk == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("createRenderKit(" +
                             config[i].getRenderKitId() + ',' +
                             config[i].getRenderKitClass() + ')');
                }
                if (config[i].getRenderKitClass() == null) {
                    throw new IllegalArgumentException// PENDING - i18n
                        ("No renderKitClass for renderKit " +
                         config[i].getRenderKitId());
                }
                rk = (RenderKit)
                    Util.loadClass(
                        config[i].getRenderKitClass(), this).newInstance();
                log.fine("renderKitV쐬o^܂" + config[i].getRenderKitId() + "," + rk);
                rkFactory.addRenderKit(config[i].getRenderKitId(), rk);
            } else {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("75) getRenderKit(" + config[i].getRenderKitId() + ')');
                }
            }
            configure(config[i].getRenderers(), rk, fallback);
        }
    }


    /**
     * <p>Configure all registered renderers for this renderkit.</p>
     *
     * @param config Array of <code>RendererBean</code> that contains
     *               our configuration information
     * @param rk     RenderKit to be configured
     */
    public void configure(RendererBean config[], RenderKit rk, Object fallback) throws Exception {

        if (config == null) {
            return;
        }

        for (int i = 0; i < config.length; i++) {

            if (log.isLoggable(Level.FINE)) {

                log.fine("100) addRenderer(" +
                         config[i].getComponentFamily() + ',' +
                         config[i].getRendererType() + ',' +
                         config[i].getRendererClass() + ')');

                log.fine("105) fallback = " + fallback);
            }

            Renderer r = (Renderer) Util.loadClass( config[i].getRendererClass(), fallback).newInstance();

            rk.addRenderer(config[i].getComponentFamily(),
                           config[i].getRendererType(),
                           r);
        }

    }


    // @see com.sun.faces.util.Util.java
    private static final String RENDER_KIT_IMPL_REQ = 
          RIConstants.FACES_PREFIX + "renderKitImplForRequest";

    public FacesContext createFacesContext(ExternalContext ec, strawberry.ResourceConfig rc) throws FacesException {
        ResourceConfigWrapper rr = new ResourceConfigWrapper(rc);
        FacesContextEL context = new FacesContextEL(ec,  null, null);

        if (application == null) {

            initLog.severe("369) Application Ă܂");
        }

        if (rkFactory == null) {

            initLog.severe("374) RenderKitFactory Ă܂" );
        }
        Map requestMap = context.getExternalContext().getRequestMap();
        requestMap.put(RENDER_KIT_IMPL_REQ, rkFactory);

        context.setApplication(application);
        context.setRenderKitFactory(rkFactory);

        GlobalELContext elc = new strawberry.el.GlobalELContext(context);
        if (elLog.isLoggable(Level.FINE))
            elLog.info("91) " + I18n.getLogMessage("strawberry.FacesContextSupportImpl.CREATE_ELCONTEXT"));

        //      elLog.info("91) " + elc + "  GlobalELContext 쐬܂-------- ");

        context.setELContext(elc);
        return context;
    }

}
