//   -*- Mode: java4; -*-
package strawberry.init;

import com.sun.facelets.FaceletFactory;
import com.sun.faces.util.Util;
import com.sun.faces.config.beans.FacesConfigBean;
import java.util.logging.*;
import javax.faces.render.RenderKitFactory;
import javax.faces.application.Application;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ViewHandler;
import javax.faces.context.ExternalContext;
import javax.faces.el.VariableResolver;

import strawberry.application.ApplicationImpl;
import strawberry.application.StateManagerImpl;
import strawberry.config.ApplicationInitializer;
import strawberry.config.RenderKitFactoryInitializer;
import strawberry.facelet.FaceletFactorySupport;
import strawberry.viewhandler.FaceletFactoryAware;
import strawberry.context.ResourceConfigWrapper;
import strawberry.el.VariableResolverImpl;
/**
 * Created on 2007/01/14,
 *            2007/06/06, faces-config.xml Ή
 * @author  masa
 */
public class ApplicationCreator {

    // jdk1.4 logging
    protected final static Logger log = Logger.getLogger("strawberry.init");

    FaceletFactorySupport ffSupport = new FaceletFactorySupport();

    /**
     *
     */
    public void initVariableResolvers(Application application, ExternalContext ec,
                                  ResourceConfigWrapper crr, FacesConfigBean fcb) {

        // application.setVariableResolver(new com.sun.faces.el.VariableResolverImpl());
        // 2007.6.12
        application.setVariableResolver(new strawberry.el.SimpleVariableResolver());
        
        if (fcb.getApplication() == null) {
            
            return;
        }
        
        String values[];
        Object instance;
        
        values = fcb.getApplication().getVariableResolvers();
        if ((values != null) && (values.length > 0)) {

            log.config("51)    variableResolvers.length() = " + values.length + " ------------------------- **");
            for (int i = 0; i < values.length; i++) {

                VariableResolver original = application.getVariableResolver();

                if (log.isLoggable(Level.CONFIG)) {
                    log.config("56) i = " + i + ", " + values[i] + " --> " + original);
                }
                
                instance = Util.createInstance(values[i],
                                               VariableResolver.class,
                                               original);

                if (instance != null) {
                    application.setVariableResolver((VariableResolver) instance);
                } else {
                  log.warning("60) i = " + i + ", " + values[i] );
                }
            }
        }
    }

    /**
     *
     */
    public void initViewHandler(Application application, ExternalContext ec,
                                  ResourceConfigWrapper crr, FacesConfigBean fcb) {
        
        application.setViewHandler(new com.sun.faces.application.ViewHandlerImpl());
        
        if (fcb.getApplication() == null) {
            
            return;
        }
        
        String values[];
        Object instance;

        values = fcb.getApplication().getViewHandlers();
        if ((values != null) && (values.length > 0)) {

            log.config("51)    viewHandlers.length() = " + values.length + " ------------------------- **");
            for (int i = 0; i < values.length; i++) {

                ViewHandler original = application.getViewHandler();

                if (log.isLoggable(Level.CONFIG)) {
                    log.config("67) i = " + i + ", " + values[i] + " --> " + original);
                }
                
                instance = Util.createInstance(values[i], ViewHandler.class,
                                               original);

                if (instance != null) {
                    
                    application.setViewHandler((ViewHandler) instance);

                    if (instance instanceof FaceletFactoryAware) {
                       FaceletFactory ff = ffSupport.createFaceletFactory( ec, crr); //////
                       FaceletFactoryAware aware = (FaceletFactoryAware) instance;
                       aware.setFaceletFactory(ff);
                    }
                } else {
                  log.warning("81) i = " + i + ", " + values[i] );
                }
            }
        }
    }
    
    /**
     *
     */
    public Application createApplication(ExternalContext ec, ResourceConfigWrapper crr,
                                         FacesConfigBean fcb) {

        log.fine("createApplication͂܂");

        ApplicationImpl application = new ApplicationImpl();

        ResourceConfigWrapper wrap = (ResourceConfigWrapper) crr;
        application.setFallbackClass(wrap.getInnerObject());

        initVariableResolvers(application, ec, crr, fcb);
        initViewHandler(application, ec, crr, fcb);

     //   fcb.getApplication().
        
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Created Application instance " + application);
        }
        return application;
    }

//    String nhClassName = "strawberry.application.NavigationHandlerEx"; // JX^}CY
    String nhClassName = "strawberry.application.NavigationHandlerImpl"; // W

    public void setNavigationHandlerClass(String className) {

        log.config("92)  setNavigationHandlerClass -------- '" + className + "'"  );
        nhClassName = className;
    }


    private NavigationHandler createNavigationHandler() {

        log.fine("99)  createNavigationHandler -------- ENTER **");
        NavigationHandler nh = null;
        try {
            log.config("102) '" + nhClassName +"' ----------- create **");
            Object wk = Class.forName(nhClassName).newInstance();
            nh = (NavigationHandler) wk;

        } catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return nh;
    }

    /**
     *  Application 
     */
    public Application initializeApplication(ExternalContext ec, ResourceConfigWrapper rr,
                                             FacesConfigBean fcb ) {

        Application app = null;
        //  strawberry.config.ApplicationInitializer
        ApplicationInitializer initializer = new ApplicationInitializer();
        try {

            // FaceletViewHandler ZbgꂽApplication
            app = createApplication(ec, rr, fcb);

            app.setActionListener(new com.sun.faces.application.ActionListenerImpl());

            initializer.configureApplication(ec, app);

            NavigationHandler  navigationHandler = createNavigationHandler();

            app.setNavigationHandler(navigationHandler);

            StateManagerImpl stateMgr = new StateManagerImpl(); // OŃZbgĂȂ̂ŁA
            app.setStateManager(stateMgr); // ōāAZbg

        } catch (Exception ex) {
            log.log(Level.SEVERE, "catch Exception", ex);
            if (ex  instanceof RuntimeException) {
                throw (RuntimeException) ex;
            } else {
              throw new RuntimeException(ex);
            }
        }
        return app;
    }


    /** RenderKitFactory  */
    public RenderKitFactory initializeRenderKitFactory(ExternalContext ec, ResourceConfigWrapper rr) {

        RenderKitFactoryInitializer  rkfi      = new RenderKitFactoryInitializer();

        log.fine("Wo^");

        RenderKitFactory  rkFactory = rkfi.configureRenderKits(ec,  rr);

        return rkFactory;
    }
}
