package strawberry.facelet;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.*;
import com.sun.facelets.tag.jsf.html.AbstractHtmlLibrary;

/**
 * @author M.HENMI
 */
public final class TagLibrary extends AbstractHtmlLibrary {

  protected final static Logger log = Logger.getLogger("strawberry.tag.TagLibrary");

  // 2007.1.26
  public final static String Namespace = "http://www.ne.jp/asahi/java/servlet/strawberry";

  public final static TagLibrary Instance = new TagLibrary();

  public TagLibrary() {
    super(Namespace);

    //----------------------------------------------
    // https://facelets.dev.java.net/nonav/docs/dev/docbook.html#architecture

    // addHtmlComponent(String name, String componentType, String rendererType)

    this.addTagHandler("initOnLoad", InitHandler.class);

    this.addTagHandler("serverSideScript", ServerSideScriptHandler.class);

//    this.addConverter("convertColumnType", "DateTimeConverter.CONVERTER_ID", ConvertColumnTypeHandler.class);

    try {
      Method[] methods = SpicaFunctions.class.getMethods();
      for (int i = 0; i < methods.length; i++) {
        if (Modifier.isStatic(methods[i].getModifiers())) {
          
          if (log.isLoggable(Level.FINE)) log.fine("֐o^ " +  methods[i].getName());

          fns.put(methods[i].getName(), methods[i]);
        }
      }
    } catch (Exception e) {
      log.log(Level.SEVERE, "103) catch Exception", e);
      throw new RuntimeException(e);
    }
  }

  private final Map fns = new HashMap();

  public boolean containsFunction(String ns, String name) {
    if (Namespace.equals(ns)) {
      return this.fns.containsKey(name);
    }
    return false;
  }

  public Method createFunction(String ns, String name) {
    if (Namespace.equals(ns)) {
      return (Method) this.fns.get(name);
    }
    return null;
  }
}
