package strawberry.facelet;

import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.context.ExternalContext;
import java.lang.reflect.Method;
/**
 * @author M.HENMI
 */
public final class SpicaFunctions {

  /**
   *  Escape the 5 entities defined by XML.
   */
  public static String escapeXml(String s) {
    if (s == null) return null;
    StringBuffer sb = new StringBuffer();
    for(int i=0; i<s.length(); i++) {
      char c = s.charAt(i);
      if (c == '<') {
        sb.append("&lt;");
      } else if (c == '>') {
        sb.append("&gt;");
      } else if (c == '\'') {
        sb.append("&apos;");
      } else if (c == '&') {
        sb.append("&amp;");
      } else if (c == '"') {
        sb.append("&quot;");
      } else {
        sb.append(c);
      }
    }
    return sb.toString();
  }


  public static String requestPathInfo() {

    FacesContext faces = FacesContext.getCurrentInstance();
    ExternalContext ec = faces.getExternalContext();
    return ec.getRequestPathInfo();
  }

  public static String requestServletPath() {

    FacesContext faces = FacesContext.getCurrentInstance();
    ExternalContext ec = faces.getExternalContext();
    return ec.getRequestServletPath();
  }

  public static String requestContextPath() {

    FacesContext faces = FacesContext.getCurrentInstance();
    ExternalContext ec = faces.getExternalContext();
    return ec.getRequestContextPath();
  }

  public static String substring2(String str, int n) {
    return str.substring(n);
  }

  public static String substring3(String str, int a, int b) {
    return str.substring(a, b);
  }

}
