//   -*- Mode: java4; -*-
package strawberry.facelet;
//package dwarf.facelet;

import java.io.IOException;

import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletHandler;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagHandler;
import java.util.logging.*;

import com.sun.facelets.tag.*;
import com.sun.facelets.tag.jsf.core.AttributeHandler;
import java.util.*;

/**
 *    Qڂ̎
 * @author mhenmi
 */
public final class ServerSideScriptHandler extends TagHandler {

    // jdk1.4 logging
    protected final static Logger log = Logger.getLogger("strawberry.script");

    private TagAttribute phase = null;
    private TagAttribute method = null;
    /**
     * @param config
     */
    public ServerSideScriptHandler(TagConfig config) {
        super(config);
        this.phase = this.getRequiredAttribute("phase");
        this.method = this.getAttribute("method");
    }

    public void apply(FaceletContext ctx, UIComponent parent)
        throws IOException, FacesException, ELException {


        Object oMethod = method.getValue(ctx);
        Object oPhase = phase.getValue(ctx);

        //log.info("46) method = " + oMethod + ", phase = " + oPhase);
        
        ServerSideScriptComponent comp = new ServerSideScriptComponent();
        String script = "";
        Iterator it = findAll();
        while (it.hasNext()) {
            Object obj = it.next();
            
            if (log.isLoggable(Level.FINE))
                log.fine("56) obj = " + obj.getClass().getName());
            //40) obj = com.sun.facelets.compiler.UIInstructionHandler


            //UIInstructionHandler AoāAcSapply?
            
            if (obj instanceof ImportHandler) {
                ImportHandler handler = (ImportHandler) obj;
                handler.apply(ctx, comp);
            } else if (obj instanceof AttributeHandler) {
                log.info("skip");
            } else {
                script += obj.toString();
            }
        }

        comp.setScript(script);

        if (oMethod != null) comp.setMethod((String) oMethod);
        if (oPhase != null) comp.setPhase((String) oPhase);
        
        parent.getChildren().add(comp);

    }
    /*TODO
aaaa
<br/>
<![CDATA[
        var t = 0;
]]>
     */


    protected final Iterator findAll() {
        List found = new ArrayList();
        if (this.nextHandler instanceof CompositeFaceletHandler) {
            FaceletHandler[] h = ((CompositeFaceletHandler) this.nextHandler).getHandlers();
            for (int i = 0; i < h.length; i++) {
                found.add(h[i]);
            }
        } else {
            found.add(this.nextHandler);
        }
        return found.iterator();
    }

}
