package strawberry.facelet;
//package dwarf.facelet;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ArrayList;
import javax.faces.component.*;

import javax.faces.context.FacesContext;
import javax.faces.context.ExternalContext;

import strawberry.FaceletsConstants;

import strawberry.lifecycle.AnyPhase;
import java.util.logging.*;

import strawberry.event.PhaseEventEx;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;

import strawberry.plugin.ScriptEngine;

/*
 * Created on 2007/03/05
 */
public class ServerSideScriptComponent extends UIComponentBase
                                       implements AnyPhase /*, JavaScriptSupport*/ {

  protected final static Logger log = Logger.getLogger("strawberry.script");
  protected final static Logger slog = Logger.getLogger("strawberry.scriptlog");

  public ServerSideScriptComponent() {
  }

  public String getFamily() {
    return "strawberry";
  }
  
  String script = "";

  public void setScript(String newValue) { script = newValue; }

  String method = null;

  public void setMethod(String newValue) { method = newValue; }


  
  int phase = 0;

  public static final String[] keywords = { "afterRestoreView",
             "beforeApplyRequestValues", "afterApplyRequestValues",
             "beforeProcessValidations", "afterProcessValidations",
             "beforeUpdateModelValues",  "afterUpdateModelValues",
             "beforeInvokeApplication",  "afterInvokeApplication",
             "beforeRenderResponse",     "afterRenderResponse",
  };

  
  public void setPhase(String newValue) {

    log.fine("55) setPhase '" + newValue + "'");
    if (newValue == null) throw new NullPointerException();

    for (int i = 0; i < keywords.length; i++) {
      if (keywords[i].equals(newValue)) {
        phase = 1 + i;
        log.fine("61) break");
        break;
      }
    }
    if (phase == 0) {
      log.info("66) IllegalArgumentException");
      throw new IllegalArgumentException(newValue +"͐܂");
    }
  }
  


  /** Cxg󂯎郁\bh */
  public void anyPhase(PhaseEventEx event) {

    PhaseEvent pe = event.getPhaseEvent();

    PhaseId pid = pe.getPhaseId();
    int ord = (pid.getOrdinal() -1) * 2;

    if (event.isAfter()) {
      ord++;
    }

    if (log.isLoggable(Level.FINER)) {
      log.finer("anyPhase  " + pid + ", after = " + event.isAfter()  );
      log.finer("83)  phase = " + phase + ", ord = " + ord );
    }
    
    if (phase == ord) {
      log.fine("scripts܂");

      FacesContext faces = pe.getFacesContext();
//      try {
      execute(faces);  //scripts
//      } catch (RuntimeException re) {
//        log.log(Level.WARNING, "RuntimeException", re);
//        throw re;
//      }

    } else {
      log.fine("scripts܂");
    }
  }


  // ꂪȂpostɂ
  public void decode(FacesContext context) {  }

  public void encodeEnd(FacesContext context) {  }
  
  public void encodeChildren(FacesContext context) {  }

  public void encodeBegin(FacesContext context) {  }




/*
  public void addImport(String newValue) {
    log.warning("arg = " + newValue + " ܂");
  }

*/  
  public void execute(FacesContext faces) {


    ArrayList importsArray = new ArrayList();
 
    importsArray.add("javax.faces.application.FacesMessage");



    ExternalContext ec = faces.getExternalContext();

    Object wk = ec.getApplicationMap().get(FaceletsConstants.ENGINE_KEY);

    ScriptEngine engine = null;

    if (wk != null && wk instanceof ScriptEngine) {
      engine = (ScriptEngine) wk;
      engine.addScriptableObject("faces", faces);

      UIViewRoot uiv = faces.getViewRoot();
      engine.addScriptableObject("root", uiv);

      engine.addScriptableObject("logging", slog);

      engine.addScriptableObject("session", faces.getExternalContext().getSessionMap());
      engine.addScriptableObject("application", faces.getExternalContext().getApplicationMap());
      engine.addScriptableObject("request", faces.getExternalContext().getRequestMap());
      engine.addScriptableObject("param", faces.getExternalContext().getRequestParameterMap());
      
      String wkScript = "";

      for (int i = 0; i < importsArray.size(); i++) {

        String tmp = (String) importsArray.get(i);

        String state = extractClassName(tmp) + " = Packages." + tmp + ";";
        
        log.fine("157) state" +  state );
        
        wkScript += state;
      }
      
      Object result = engine.evaluateString( wkScript + script, "<cmd>", 1);
    } else {
      log.warning("ENGINE ݂܂");
    }
  }

  public String extractClassName(String fullName) {
    int idx = fullName.lastIndexOf(".");
    return fullName.substring(idx + 1);
    
  }


}
