/*
 * Copyright (C) 2006 Masahito Henmi, All rights reserved.
 */
package strawberry.facelet;

import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import java.util.logging.*;
/**
 * Created on 2006/11/03, 19:21
 *
 * @author masa
 */
public class PhaseListenerImpl implements PhaseListener {
  
  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.PhaseListenerImpl");
  /** Creates a new instance of PhaseListenerImpl */
  public PhaseListenerImpl() {
  }
  
  public PhaseId getPhaseId() {
    return PhaseId.ANY_PHASE;
    
  }
  
  public void beforePhase(PhaseEvent event) {
    log.info("[BEFORE]" + event.getPhaseId());
  }
  
  public void afterPhase(PhaseEvent event) {
    log.info("[AFTER]" + event.getPhaseId());
  }
  
}
