//   -*- Mode: java4; -*-
package strawberry.facelet;

import java.io.IOException;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.component.UIComponent;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagHandler;
import java.lang.reflect.Method;
import java.util.logging.*;
import javax.faces.el.VariableResolver;

/**
 * w肳ꂽr[̎w肳ꂽ\bhĂԃ^O
 *
 * @author mhenmi
 */
public final class InitHandler extends TagHandler {

    // jdk1.4 logging
    protected final static Logger log = Logger.getLogger("strawberry.tag.InitHandler");

    private TagAttribute taBean = null;
    private TagAttribute taMethod = null;
    /**
     * @param config
     */
    public InitHandler(TagConfig config) {
        super(config);
        this.taBean = this.getRequiredAttribute("bean");
        this.taMethod = this.getRequiredAttribute("method");
    }

    public void apply(FaceletContext ctx, UIComponent parent)
        throws IOException, FacesException, ELException {

        String sBean = taBean.getValue(ctx);
        String sMethod = taMethod.getValue(ctx);

        log.fine("bean = '" + sBean + "'");
        log.fine("method = '" + sMethod + "'");


        FacesContext faces = ctx.getFacesContext();


        // HH  FacesContext瓾H
        // VariableResolverImpl vri = new VariableResolverImpl();

        VariableResolver vri = faces.getApplication().getVariableResolver();

        Object obj = vri.resolveVariable(faces, sBean);

        callMethod(obj, sMethod);
    }


    /**
     *  tNVgāA\bhĂ
     */
    public Object callMethod(Object bean, String methodName) {
        Object ret = null;
        Class cls = bean.getClass();
        try {
            Method method = cls.getMethod(methodName, (Class[]) null);
            // \bhs
            ret = method.invoke(bean, (Object[]) null);
        } catch (Exception ex) {
            log.log(Level.SEVERE, "(76)catch Exception " + ex.getMessage(), ex);
        }

        return ret;
    }

}
