/*  -*- Mode: java4; -*-
 *
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at
 * https://javaserverfaces.dev.java.net/CDDL.html or
 * legal/CDDLv1.0.txt. 
 * See the License for the specific language governing
 * permission and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at legal/CDDLv1.0.txt.    
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * 
 * 
 * "Portions Copyrighted [2007] [MASAHITO HENMI]"
 * 
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package strawberry.el;

import com.sun.faces.RIConstants;

import strawberry.application.ApplicationAssociate;

import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.VariableResolver;
import java.util.Collections;
import java.util.HashMap;
import java.util.logging.*;

/**
 *     @see strawberry.el.Next6ValueExpression  ގR[h
 */
public class VariableResolverImpl extends VariableResolver {

    // jdk1.4 logging
    protected final static Logger log = Logger.getLogger("strawberry.el");

    /**
     *
     */
    public Object resolveVariable(FacesContext context, String name) throws EvaluationException {

        log.fine("resolveVariable ------------------------------------- **");

        ExternalContext ec = context.getExternalContext();

        if (RIConstants.APPLICATION_SCOPE.equals(name)) {
            return (ec.getApplicationMap());
        } else if (RIConstants.COOKIE_IMPLICIT_OBJ.equals(name)) {
            return (ec.getRequestCookieMap());
        } else if (RIConstants.FACES_CONTEXT_IMPLICIT_OBJ.equals(name)){
            log.finer("(69) => " + context);
            return (context);
        } else if (RIConstants.HEADER_IMPLICIT_OBJ.equals(name)) {
            return (ec.getRequestHeaderMap());
        } else if (RIConstants.HEADER_VALUES_IMPLICIT_OBJ.equals(name)){
            return (ec.getRequestHeaderValuesMap());
        } else if (RIConstants.INIT_PARAM_IMPLICIT_OBJ.equals(name)) {
            return (ec.getInitParameterMap());
        } else if (RIConstants.PARAM_IMPLICIT_OBJ.equals(name)) {
            return (ec.getRequestParameterMap());
        } else if (RIConstants.PARAM_VALUES_IMPLICIT_OBJ.equals(name)) {
            return (ec.getRequestParameterValuesMap());
        } else if (RIConstants.REQUEST_SCOPE.equals(name)) {
            return (ec.getRequestMap());
        } else if (RIConstants.SESSION_SCOPE.equals(name)) {
            return (ec.getSessionMap());
        } else if (RIConstants.VIEW_IMPLICIT_OBJ.equals(name)) {
            return (context.getViewRoot());
        } else {
            // do the scoped lookup thing
            Object value = null;

            if (name.startsWith("autoHashMap")) {

                if (null == (value = ec.getSessionMap().get(name))) {
                    value = Collections.synchronizedMap(new HashMap());
                    ec.getSessionMap().put(name, value);
                }

            } else {
                if (null == (value = ec.getRequestMap().get(name))) {
                    if (null == (value = ec.getSessionMap().get(name))) {
                        if (null == (value = ec.getApplicationMap().get(name))) {
                            // if it's a managed bean try and create it
                            ApplicationAssociate associate =
                                ApplicationAssociate.getInstance(context.getExternalContext());

                            if (null != associate) {
                                //log.debug("(100) ********** associate != null ");
                                value = associate.createAndMaybeStoreManagedBeans(context,
                                                                                  name);
                            } else {
                                log.info("(104) ********** associate is null !!");
                            }
                        }
                    }
                }
            }
            if (log.isLoggable(Level.FINEST)) {
                String wk = "null";
                if (value != null) wk = value.toString();
                if (wk.length() > 70) wk = wk.substring(0, 70);
                log.finest("resolveVariable: Resolved variable:" + wk);
            }
            return (value);
        }

    }
}
