/*  -*- Mode: java4; -*-
 *
 * Copyright (C)  2007 Masahito Henmi, All rights reserved.
 */

package strawberry.el;

import java.util.GregorianCalendar;

import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.VariableResolver;
import java.util.logging.*;

/**
 *     eXgp
 */
public class TestVariableResolver extends VariableResolver {

    // jdk1.4 logging
    protected final static Logger log = Logger.getLogger("strawberry.el");

    VariableResolver original = null;

    public TestVariableResolver(VariableResolver original) {
        this.original = original;

        log.info("*****************************  RXgN^ original = " + original);
    }

    

    // Specified by javax.faces.el.VariableResolver.resolveVariable()
    public Object resolveVariable(FacesContext context, String name) throws EvaluationException {

        ExternalContext ec = context.getExternalContext();

        log.info("name - " + name + " ************* ENTER");
        if ("CALENDAR".equals(name)) {
            
            log.info("  ==> cal " );
            return new GregorianCalendar();
        } else {

            Object value = original.resolveVariable(context, name);

            if (log.isLoggable(Level.FINEST)) {
                String wk = "null";
                if (value != null) wk = value.toString();
                if (wk.length() > 70) wk = wk.substring(0, 70);
                log.finest("resolveVariable: Resolved variable:" + wk);
            }
            return (value);
        }

    }
}
