/*  -*- Mode: java4; -*-
 * 
 * "Portions Copyrighted [2007] [MASAHITO HENMI]"
 * 
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package strawberry.el;

import com.sun.faces.RIConstants;

import strawberry.application.ApplicationAssociate;

import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.VariableResolver;
import java.util.Collections;
import java.util.HashMap;
import java.util.logging.*;

/**
 *     @see strawberry.el.Next6ValueExpression  ގR[h
 */
public class SimpleVariableResolver extends VariableResolver {

    // jdk1.4 logging
    protected final static Logger log = Logger.getLogger("strawberry.el");

    /**
     *
     */
    public Object resolveVariable(FacesContext context, String name) throws EvaluationException {

        log.fine("resolveVariable ------------------------------------- **");

        ExternalContext ec = context.getExternalContext();

        if (RIConstants.APPLICATION_SCOPE.equals(name)) {
            return (ec.getApplicationMap());
        } else if (RIConstants.PARAM_IMPLICIT_OBJ.equals(name)) {
            return (ec.getRequestParameterMap());
        } else if (RIConstants.SESSION_SCOPE.equals(name)) {
            return (ec.getSessionMap());
        } else {
            // do the scoped lookup thing
            Object value = null;

            if (name.startsWith("autoHashMap")) {

                if (null == (value = ec.getSessionMap().get(name))) {
                    value = Collections.synchronizedMap(new HashMap());
                    ec.getSessionMap().put(name, value);
                }

            } else {
                if (null == (value = ec.getRequestMap().get(name))) {
                    if (null == (value = ec.getSessionMap().get(name))) {
                        if (null == (value = ec.getApplicationMap().get(name))) {
                            // if it's a managed bean try and create it
                            ApplicationAssociate associate =
                                ApplicationAssociate.getInstance(context.getExternalContext());

                            if (null != associate) {
                                //log.debug("(100) ********** associate != null ");
                                value = associate.createAndMaybeStoreManagedBeans(context,
                                                                                  name);
                            } else {
                                log.info("(104) ********** associate is null !!");
                            }
                        }
                    }
                }
            }
            if (log.isLoggable(Level.FINEST)) {
                String wk = "null";
                if (value != null) wk = value.toString();
                if (wk.length() > 70) wk = wk.substring(0, 70);
                log.finest("resolveVariable: Resolved variable:" + wk);
            }
            return (value);
        }

    }
}
