/*
 * Copyright (C)  2007 Masahito Henmi, All rights reserved.
 */
package strawberry.el;

import com.sun.faces.RIConstants;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

import java.util.logging.*;
/**
 * Created on 2007/02/19
 * @author masa
 */
public class Next6VariableMapper extends VariableMapper {
  
  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.el");

  FacesContext fc = null;
  /** Creates a new instance of Next6VariableMapper */
  public Next6VariableMapper(FacesContext fc) {
    this.fc = fc;
  }

  public ValueExpression resolveVariable(String name) {
    return new Next6ValueExpression(/*fc,*/ name);  
  }

  public ValueExpression setVariable(String variable, ValueExpression expression) {
    log.info("setVariable:" + variable + ", " + expression);
    return new Next6ValueExpression(/*fc,*/ variable);  
  }
  
}
