/*
 * Copyright (C)  2007 Masahito Henmi, All rights reserved.
 */
package strawberry.el;

import java.util.Iterator;
import java.util.Map;
import java.util.logging.*;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
//import org.apache.commons.beanutils.PropertyUtils;
/**
 * Created on 2007/02/17
 *            2007/06/10  commons.beanutils.PropertyUtils
 * @author masa
 */
public class GlobalELResolver extends ELResolver {
  
  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.el.variable");
  
  /** Creates a new instance of GlobalELResolver */
  public GlobalELResolver() {
  }

  public void setValue(ELContext context, Object base, Object property, Object value) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, ELException {


    try {
      pri.setValue(base, property, value);
      
    } catch (Exception ex) {
       log.severe("setValue************************* " + base.getClass().getName() + ", " + property  );
         log.log(Level.SEVERE, "34) Exception",ex);
          throw new ELException(ex.toString());
    }
/*
    if (base instanceof Map) { // 2007.6.14 fix
      Map map = (Map) base;
      map.put(property, value);
    } else {

      try {
        PropertyUtils.setProperty(base, property.toString(), value);
      } catch (Exception ex) {
          throw new ELException(ex.toString());
      }
    }*/
  }

  public boolean isReadOnly(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
    log.severe("isReadOnly*************************");
    throw new UnsupportedOperationException();
  }

  com.sun.faces.el.PropertyResolverImpl pri = new com.sun.faces.el.PropertyResolverImpl();
  
  public Object getValue(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {

    //String strBase = base.toString();
    // TODO: basegslkɂȂ鎖
    //log.debug("getValue   " + base + ", " + property );
    
    log.fine("getValue************************* " + base.getClass().getName() + ", " + property  );
    Object obj = null;
    try {
      obj = pri.getValue(base, property);
    } catch (Exception ex) {
         log.log(Level.SEVERE, "69) Exception",ex);
        throw new ELException(ex.toString());
    }
    return obj;
      //return null;//2006.6.10 
/*
    if (base instanceof Map) { // 2007.6.14 fix
      Map map = (Map) base;
      return map.get(property);
    } else {

      Object ans = null;
      try {
        ans = PropertyUtils.getProperty(base, property.toString());
      } catch (Exception ex) {
        throw new ELException(ex.toString());
      }
      return ans;
    }*/
  }

  public Class getType(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
    log.finer("getType");

    Class cls = null;
    try {
      cls = pri.getType(base, property);
    } catch (Exception ex) {
         log.severe("97) Exception");
        throw new ELException(ex.toString());
    }
    return cls;
//    log.fine("getType*************************");
//    return null;//2006.6.10 
  }

  public Iterator getFeatureDescriptors(ELContext context, Object base) {
    log.severe("getFeatureDescriptors");
    throw new UnsupportedOperationException();
  }

  public Class getCommonPropertyType(ELContext context, Object base) {
    log.severe("getCommonPropertyType");
    throw new UnsupportedOperationException();
  }
  
}
