/*
 * Copyright (C)  2007 Masahito Henmi, All rights reserved.
 */
package strawberry.el;

import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.FunctionMapper;
import javax.el.VariableMapper;
import javax.faces.context.FacesContext;
import org.apache.el.lang.FunctionMapperImpl;
import java.util.logging.*;
/**
 *  2007/02/17  VK쐬
 *
 *  2007/04/16  com.sun.facelets.el.LegacyELContext ̃NXƎ@\𔭌B
 *
 * @author masa
 */
public class GlobalELContext extends ELContext {
  
  // jdk1.4 logging
  protected final static Logger varLog = Logger.getLogger("strawberry.el.variable");
  protected final static Logger funLog = Logger.getLogger("strawberry.el.function");

  VariableMapper vm = null;
  FunctionMapper fm = null;   //  new FunctionMapperImpl(); 2007.4.16 lnullɕύX

  GlobalELResolver elr = new GlobalELResolver();
  
  /** Creates a new instance */
  public GlobalELContext(FacesContext fc) {
    vm = new VariableMapperEx(fc);
  }

  public VariableMapper getVariableMapper() {
    return vm;
  }

  public FunctionMapper getFunctionMapper() {
    return fm;
  }

  public void setFunctionMapper(FunctionMapper newValue) {
    if (funLog.isLoggable(Level.FINE))
      funLog.fine("setFunctionMapper = " + newValue + " ---------- ");
    fm = newValue;
  }

  public ELResolver getELResolver() {
    return elr;
  }
  
}
