/*   -*- Mode: java4; -*-
 *
 * Copyright (C)  2007 Masahito Henmi, All rights reserved.
 */

package strawberry.el;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.List;

import javax.el.FunctionMapper;
import com.sun.facelets.tag.TagLibrary;
import java.util.logging.*;
/**
 * 
 */
public class DeserializedFunctionMapper extends FunctionMapper /*implements Externalizable*/ {

    // jdk1.4 logging
    protected final static Logger log = Logger.getLogger("strawberry.el.funmap");
  
    private static final long serialVersionUID = 1L;
    

    List taglibs = null;
    Map ns = null;
/*
    public DeserializedFunctionMapper(List taglibs) {
        this.taglibs = taglibs;
    }
*/
    public DeserializedFunctionMapper(Map ns, List taglibs) {
        this.ns = ns;
        this.taglibs = taglibs;
        log.fine("39) ns = " + ns + ", taglib = " + taglibs);
    }
    
    /*
     * (non-Javadoc)
     * 
     * @see javax.el.FunctionMapper#resolveFunction(java.lang.String,
     *      java.lang.String)
     */
    public Method resolveFunction(String prefix, String localName) {

        String ns = prefix2ns(prefix);

        // Ql CompositeTagLibrary#createFunction
        for (int i = 0; i < taglibs.size(); i++) {

            TagLibrary tl = (TagLibrary) taglibs.get(i);
            if (tl.containsFunction(ns, localName)) {
                Method me = tl.createFunction(ns, localName);
                return me;
            }
        }

        return null;
    }

    /**
     *
     *
     *
     *   Ql   com.sun.facelets.compiler.NamespaceHandler#resolveFunction
     */
    public String prefix2ns(String prefix) {

        String wk = (String) ns.get(prefix);
        log.fine("74) prefix = " + prefix + " => " + wk);
        //return "http://www.ne.jp/asahi/java/servlet";
        return wk;
    }


    
    /*


    public void addFunction(String prefix, String localName, Method m) {
        if (this.functions == null) {
            this.functions = new HashMap();
        }
        Function f = new Function(prefix, localName, m);
        synchronized (this) {
            this.functions.put(prefix+":"+localName, f);
        }
    }
*/


}
