package strawberry.config;

import strawberry.ctx.ExternalContextImpl2;
import com.sun.faces.context.FacesContextImpl;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import strawberry.application.ApplicationAssociate;
import strawberry.el.GlobalELContext;
import java.util.logging.*;
/**
 * Created on 2007.5.24
 *
 * @author masa
 */
public class MBeanSupport {

  // jdk1.4 logging
  protected final static Logger log = Logger.getLogger("strawberry.bean.MBeanSupport");


  public static Object createAndMaybeStoreManagedBeans(ServletRequest request,
                                                ServletResponse response,
                                                ServletContext sc,
                                                String managedBeanName) {

    ExternalContextImpl2 ec = new ExternalContextImpl2(sc, request, response);
    Object bean = null;
    FacesContextImpl fci = new FacesContextImpl(ec, null, null);
    try {

      GlobalELContext elc = new strawberry.el.GlobalELContext(fci);
      if (log.isLoggable(Level.FINE))
        log.info("33) " + elc + "  GlobalELContext 쐬܂-------- ");
      fci.setELContext(elc);
      
      ApplicationAssociate aa = ApplicationAssociate.getInstance(sc);
      bean = aa.createAndMaybeStoreManagedBeans(fci, managedBeanName);
    } finally {
      fci.release();
    }
    return bean;
  }
  
  
}
